@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property maxCapacity Maximum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid capacity values are in a range of `0.5` up to `128` in steps of `0.5`.
 * @property minCapacity Minimum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid capacity values are in a range of `0.5` up to `128` in steps of `0.5`.
 */
public data class ClusterServerlessv2ScalingConfiguration(
    public val maxCapacity: Double,
    public val minCapacity: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.ClusterServerlessv2ScalingConfiguration): ClusterServerlessv2ScalingConfiguration = ClusterServerlessv2ScalingConfiguration(
            maxCapacity = javaType.maxCapacity(),
            minCapacity = javaType.minCapacity(),
        )
    }
}
