@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getClusterParameterGroup.
 * @property arn ARN of the cluster parameter group.
 * @property description Description of the cluster parameter group.
 * @property family Family of the cluster parameter group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 */
public data class GetClusterParameterGroupResult(
    public val arn: String,
    public val description: String,
    public val family: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetClusterParameterGroupResult): GetClusterParameterGroupResult = GetClusterParameterGroupResult(
            arn = javaType.arn(),
            description = javaType.description(),
            family = javaType.family(),
            id = javaType.id(),
            name = javaType.name(),
        )
    }
}
