@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getClusterSnapshot.
 * @property allocatedStorage Allocated storage size in gigabytes (GB).
 * @property availabilityZones List of EC2 Availability Zones that instances in the DB cluster snapshot can be restored in.
 * @property dbClusterIdentifier Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was created from.
 * @property dbClusterSnapshotArn The ARN for the DB Cluster Snapshot.
 * @property dbClusterSnapshotIdentifier
 * @property engine Name of the database engine.
 * @property engineVersion Version of the database engine for this DB cluster snapshot.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property includePublic
 * @property includeShared
 * @property kmsKeyId If storage_encrypted is true, the AWS KMS key identifier for the encrypted DB cluster snapshot.
 * @property licenseModel License model information for the restored DB cluster.
 * @property mostRecent
 * @property port Port that the DB cluster was listening on at the time of the snapshot.
 * @property snapshotCreateTime Time when the snapshot was taken, in Universal Coordinated Time (UTC).
 * @property snapshotType
 * @property sourceDbClusterSnapshotArn
 * @property status Status of this DB Cluster Snapshot.
 * @property storageEncrypted Whether the DB cluster snapshot is encrypted.
 * @property tags Map of tags for the resource.
 * @property vpcId VPC ID associated with the DB cluster snapshot.
 */
public data class GetClusterSnapshotResult(
    public val allocatedStorage: Int,
    public val availabilityZones: List<String>,
    public val dbClusterIdentifier: String? = null,
    public val dbClusterSnapshotArn: String,
    public val dbClusterSnapshotIdentifier: String? = null,
    public val engine: String,
    public val engineVersion: String,
    public val id: String,
    public val includePublic: Boolean? = null,
    public val includeShared: Boolean? = null,
    public val kmsKeyId: String,
    public val licenseModel: String,
    public val mostRecent: Boolean? = null,
    public val port: Int,
    public val snapshotCreateTime: String,
    public val snapshotType: String? = null,
    public val sourceDbClusterSnapshotArn: String,
    public val status: String,
    public val storageEncrypted: Boolean,
    public val tags: Map<String, String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetClusterSnapshotResult): GetClusterSnapshotResult = GetClusterSnapshotResult(
            allocatedStorage = javaType.allocatedStorage(),
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            dbClusterIdentifier = javaType.dbClusterIdentifier().map({ args0 -> args0 }).orElse(null),
            dbClusterSnapshotArn = javaType.dbClusterSnapshotArn(),
            dbClusterSnapshotIdentifier = javaType.dbClusterSnapshotIdentifier().map({ args0 ->
                args0
            }).orElse(null),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            id = javaType.id(),
            includePublic = javaType.includePublic().map({ args0 -> args0 }).orElse(null),
            includeShared = javaType.includeShared().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId(),
            licenseModel = javaType.licenseModel(),
            mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
            port = javaType.port(),
            snapshotCreateTime = javaType.snapshotCreateTime(),
            snapshotType = javaType.snapshotType().map({ args0 -> args0 }).orElse(null),
            sourceDbClusterSnapshotArn = javaType.sourceDbClusterSnapshotArn(),
            status = javaType.status(),
            storageEncrypted = javaType.storageEncrypted(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
        )
    }
}
