@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getClusters.
 * @property clusterArns Set of cluster ARNs of the matched RDS clusters.
 * @property clusterIdentifiers Set of ARNs of cluster identifiers of the matched RDS clusters.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetClustersResult(
    public val clusterArns: List<String>,
    public val clusterIdentifiers: List<String>,
    public val filters: List<GetClustersFilter>? = null,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetClustersResult): GetClustersResult =
            GetClustersResult(
                clusterArns = javaType.clusterArns().map({ args0 -> args0 }),
                clusterIdentifiers = javaType.clusterIdentifiers().map({ args0 -> args0 }),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.rds.kotlin.outputs.GetClustersFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
            )
    }
}
