@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEngineVersion.
 * @property defaultCharacterSet Default character set for new instances of the engine version.
 * @property defaultOnly
 * @property engine
 * @property engineDescription Description of the engine.
 * @property exportableLogTypes Set of log types that the engine version has available for export to CloudWatch Logs.
 * @property filters
 * @property hasMajorTarget
 * @property hasMinorTarget
 * @property id The provider-assigned unique ID for this managed resource.
 * @property includeAll
 * @property latest
 * @property parameterGroupFamily
 * @property preferredMajorTargets
 * @property preferredUpgradeTargets
 * @property preferredVersions
 * @property status Status of the engine version, either `available` or `deprecated`.
 * @property supportedCharacterSets Set of character sets supported by th engine version.
 * @property supportedFeatureNames Set of features supported by the engine version.
 * @property supportedModes Set of supported engine version modes.
 * @property supportedTimezones Set of the time zones supported by the engine version.
 * @property supportsGlobalDatabases Whether you can use Aurora global databases with the engine version.
 * @property supportsLimitlessDatabase Whether the engine version supports Aurora Limitless Database.
 * @property supportsLogExportsToCloudwatch Whether the engine version supports exporting the log types specified by `exportable_log_types` to CloudWatch Logs.
 * @property supportsParallelQuery Whether you can use Aurora parallel query with the engine version.
 * @property supportsReadReplica Whether the engine version supports read replicas.
 * @property validMajorTargets Set of versions that are valid major version upgrades for the engine version.
 * @property validMinorTargets Set of versions that are valid minor version upgrades for the engine version.
 * @property validUpgradeTargets Set of versions that are valid major or minor upgrades for the engine version.
 * @property version
 * @property versionActual Complete engine version.
 * @property versionDescription Description of the engine version.
 */
public data class GetEngineVersionResult(
    public val defaultCharacterSet: String,
    public val defaultOnly: Boolean? = null,
    public val engine: String,
    public val engineDescription: String,
    public val exportableLogTypes: List<String>,
    public val filters: List<GetEngineVersionFilter>? = null,
    public val hasMajorTarget: Boolean? = null,
    public val hasMinorTarget: Boolean? = null,
    public val id: String,
    public val includeAll: Boolean? = null,
    public val latest: Boolean? = null,
    public val parameterGroupFamily: String,
    public val preferredMajorTargets: List<String>? = null,
    public val preferredUpgradeTargets: List<String>? = null,
    public val preferredVersions: List<String>? = null,
    public val status: String,
    public val supportedCharacterSets: List<String>,
    public val supportedFeatureNames: List<String>,
    public val supportedModes: List<String>,
    public val supportedTimezones: List<String>,
    public val supportsGlobalDatabases: Boolean,
    public val supportsLimitlessDatabase: Boolean,
    public val supportsLogExportsToCloudwatch: Boolean,
    public val supportsParallelQuery: Boolean,
    public val supportsReadReplica: Boolean,
    public val validMajorTargets: List<String>,
    public val validMinorTargets: List<String>,
    public val validUpgradeTargets: List<String>,
    public val version: String,
    public val versionActual: String,
    public val versionDescription: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetEngineVersionResult): GetEngineVersionResult = GetEngineVersionResult(
            defaultCharacterSet = javaType.defaultCharacterSet(),
            defaultOnly = javaType.defaultOnly().map({ args0 -> args0 }).orElse(null),
            engine = javaType.engine(),
            engineDescription = javaType.engineDescription(),
            exportableLogTypes = javaType.exportableLogTypes().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.rds.kotlin.outputs.GetEngineVersionFilter.Companion.toKotlin(args0)
                })
            }),
            hasMajorTarget = javaType.hasMajorTarget().map({ args0 -> args0 }).orElse(null),
            hasMinorTarget = javaType.hasMinorTarget().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            includeAll = javaType.includeAll().map({ args0 -> args0 }).orElse(null),
            latest = javaType.latest().map({ args0 -> args0 }).orElse(null),
            parameterGroupFamily = javaType.parameterGroupFamily(),
            preferredMajorTargets = javaType.preferredMajorTargets().map({ args0 -> args0 }),
            preferredUpgradeTargets = javaType.preferredUpgradeTargets().map({ args0 -> args0 }),
            preferredVersions = javaType.preferredVersions().map({ args0 -> args0 }),
            status = javaType.status(),
            supportedCharacterSets = javaType.supportedCharacterSets().map({ args0 -> args0 }),
            supportedFeatureNames = javaType.supportedFeatureNames().map({ args0 -> args0 }),
            supportedModes = javaType.supportedModes().map({ args0 -> args0 }),
            supportedTimezones = javaType.supportedTimezones().map({ args0 -> args0 }),
            supportsGlobalDatabases = javaType.supportsGlobalDatabases(),
            supportsLimitlessDatabase = javaType.supportsLimitlessDatabase(),
            supportsLogExportsToCloudwatch = javaType.supportsLogExportsToCloudwatch(),
            supportsParallelQuery = javaType.supportsParallelQuery(),
            supportsReadReplica = javaType.supportsReadReplica(),
            validMajorTargets = javaType.validMajorTargets().map({ args0 -> args0 }),
            validMinorTargets = javaType.validMinorTargets().map({ args0 -> args0 }),
            validUpgradeTargets = javaType.validUpgradeTargets().map({ args0 -> args0 }),
            version = javaType.version(),
            versionActual = javaType.versionActual(),
            versionDescription = javaType.versionDescription(),
        )
    }
}
