@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEventCategories.
 * @property eventCategories List of the event categories.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property sourceType
 */
public data class GetEventCategoriesResult(
    public val eventCategories: List<String>,
    public val id: String,
    public val sourceType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetEventCategoriesResult): GetEventCategoriesResult = GetEventCategoriesResult(
            eventCategories = javaType.eventCategories().map({ args0 -> args0 }),
            id = javaType.id(),
            sourceType = javaType.sourceType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
