@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId The Amazon Web Services KMS key identifier that is used to encrypt the secret.
 * @property secretArn The Amazon Resource Name (ARN) of the secret.
 * @property secretStatus The status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
 */
public data class GetInstanceMasterUserSecret(
    public val kmsKeyId: String,
    public val secretArn: String,
    public val secretStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetInstanceMasterUserSecret): GetInstanceMasterUserSecret = GetInstanceMasterUserSecret(
            kmsKeyId = javaType.kmsKeyId(),
            secretArn = javaType.secretArn(),
            secretStatus = javaType.secretStatus(),
        )
    }
}
