@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInstance.
 * @property address Hostname of the RDS instance. See also `endpoint` and `port`.
 * @property allocatedStorage Allocated storage size specified in gigabytes.
 * @property autoMinorVersionUpgrade Indicates that minor version patches are applied automatically.
 * @property availabilityZone Name of the Availability Zone the DB instance is located in.
 * @property backupRetentionPeriod Specifies the number of days for which automatic DB snapshots are retained.
 * @property caCertIdentifier Identifier of the CA certificate for the DB instance.
 * @property dbClusterIdentifier If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.
 * @property dbInstanceArn ARN for the DB instance.
 * @property dbInstanceClass Contains the name of the compute and memory capacity class of the DB instance.
 * @property dbInstanceIdentifier
 * @property dbInstancePort Port that the DB instance listens on.
 * @property dbName Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.
 * @property dbParameterGroups Provides the list of DB parameter groups applied to this DB instance.
 * @property dbSubnetGroup Name of the subnet group associated with the DB instance.
 * @property enabledCloudwatchLogsExports List of log types to export to cloudwatch.
 * @property endpoint Connection endpoint in `address:port` format.
 * @property engine Provides the name of the database engine to be used for this DB instance.
 * @property engineVersion Database engine version.
 * @property hostedZoneId Canonical hosted zone ID of the DB instance (to be used in a Route 53 Alias record).
 * @property id The provider-assigned unique ID for this managed resource.
 * @property iops Provisioned IOPS (I/O operations per second) value.
 * @property kmsKeyId The Amazon Web Services KMS key identifier that is used to encrypt the secret.
 * @property licenseModel License model information for this DB instance.
 * @property masterUserSecrets Provides the master user secret. Only available when `manage_master_user_password` is set to true. Documented below.
 * @property masterUsername Contains the master username for the DB instance.
 * @property maxAllocatedStorage The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.
 * @property monitoringInterval Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
 * @property monitoringRoleArn ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to CloudWatch Logs.
 * @property multiAz If the DB instance is a Multi-AZ deployment.
 * @property networkType Network type of the DB instance.
 * @property optionGroupMemberships Provides the list of option group memberships for this DB instance.
 * @property port Database endpoint port, primarily used by an Aurora DB cluster. For a conventional RDS DB instance, the `db_instance_port` is typically the preferred choice.
 * @property preferredBackupWindow Specifies the daily time range during which automated backups are created.
 * @property preferredMaintenanceWindow Specifies the weekly time range during which system maintenance can occur in UTC.
 * @property publiclyAccessible Accessibility options for the DB instance.
 * @property replicateSourceDb Identifier of the source DB that this is a replica of.
 * @property resourceId RDS Resource ID of this instance.
 * @property storageEncrypted Whether the DB instance is encrypted.
 * @property storageThroughput Storage throughput value for the DB instance.
 * @property storageType Storage type associated with DB instance.
 * @property tags
 * @property timezone Time zone of the DB instance.
 * @property vpcSecurityGroups Provides a list of VPC security group elements that the DB instance belongs to.
 */
public data class GetInstanceResult(
    public val address: String,
    public val allocatedStorage: Int,
    public val autoMinorVersionUpgrade: Boolean,
    public val availabilityZone: String,
    public val backupRetentionPeriod: Int,
    public val caCertIdentifier: String,
    public val dbClusterIdentifier: String,
    public val dbInstanceArn: String,
    public val dbInstanceClass: String,
    public val dbInstanceIdentifier: String,
    public val dbInstancePort: Int,
    public val dbName: String,
    public val dbParameterGroups: List<String>,
    public val dbSubnetGroup: String,
    public val enabledCloudwatchLogsExports: List<String>,
    public val endpoint: String,
    public val engine: String,
    public val engineVersion: String,
    public val hostedZoneId: String,
    public val id: String,
    public val iops: Int,
    public val kmsKeyId: String,
    public val licenseModel: String,
    public val masterUserSecrets: List<GetInstanceMasterUserSecret>,
    public val masterUsername: String,
    public val maxAllocatedStorage: Int,
    public val monitoringInterval: Int,
    public val monitoringRoleArn: String,
    public val multiAz: Boolean,
    public val networkType: String,
    public val optionGroupMemberships: List<String>,
    public val port: Int,
    public val preferredBackupWindow: String,
    public val preferredMaintenanceWindow: String,
    public val publiclyAccessible: Boolean,
    public val replicateSourceDb: String,
    public val resourceId: String,
    public val storageEncrypted: Boolean,
    public val storageThroughput: Int,
    public val storageType: String,
    public val tags: Map<String, String>,
    public val timezone: String,
    public val vpcSecurityGroups: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetInstanceResult): GetInstanceResult =
            GetInstanceResult(
                address = javaType.address(),
                allocatedStorage = javaType.allocatedStorage(),
                autoMinorVersionUpgrade = javaType.autoMinorVersionUpgrade(),
                availabilityZone = javaType.availabilityZone(),
                backupRetentionPeriod = javaType.backupRetentionPeriod(),
                caCertIdentifier = javaType.caCertIdentifier(),
                dbClusterIdentifier = javaType.dbClusterIdentifier(),
                dbInstanceArn = javaType.dbInstanceArn(),
                dbInstanceClass = javaType.dbInstanceClass(),
                dbInstanceIdentifier = javaType.dbInstanceIdentifier(),
                dbInstancePort = javaType.dbInstancePort(),
                dbName = javaType.dbName(),
                dbParameterGroups = javaType.dbParameterGroups().map({ args0 -> args0 }),
                dbSubnetGroup = javaType.dbSubnetGroup(),
                enabledCloudwatchLogsExports = javaType.enabledCloudwatchLogsExports().map({ args0 -> args0 }),
                endpoint = javaType.endpoint(),
                engine = javaType.engine(),
                engineVersion = javaType.engineVersion(),
                hostedZoneId = javaType.hostedZoneId(),
                id = javaType.id(),
                iops = javaType.iops(),
                kmsKeyId = javaType.kmsKeyId(),
                licenseModel = javaType.licenseModel(),
                masterUserSecrets = javaType.masterUserSecrets().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.rds.kotlin.outputs.GetInstanceMasterUserSecret.Companion.toKotlin(args0)
                    })
                }),
                masterUsername = javaType.masterUsername(),
                maxAllocatedStorage = javaType.maxAllocatedStorage(),
                monitoringInterval = javaType.monitoringInterval(),
                monitoringRoleArn = javaType.monitoringRoleArn(),
                multiAz = javaType.multiAz(),
                networkType = javaType.networkType(),
                optionGroupMemberships = javaType.optionGroupMemberships().map({ args0 -> args0 }),
                port = javaType.port(),
                preferredBackupWindow = javaType.preferredBackupWindow(),
                preferredMaintenanceWindow = javaType.preferredMaintenanceWindow(),
                publiclyAccessible = javaType.publiclyAccessible(),
                replicateSourceDb = javaType.replicateSourceDb(),
                resourceId = javaType.resourceId(),
                storageEncrypted = javaType.storageEncrypted(),
                storageThroughput = javaType.storageThroughput(),
                storageType = javaType.storageType(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                timezone = javaType.timezone(),
                vpcSecurityGroups = javaType.vpcSecurityGroups().map({ args0 -> args0 }),
            )
    }
}
