@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInstances.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceArns ARNs of the matched RDS instances.
 * @property instanceIdentifiers Identifiers of the matched RDS instances.
 * @property tags
 */
public data class GetInstancesResult(
    public val filters: List<GetInstancesFilter>? = null,
    public val id: String,
    public val instanceArns: List<String>,
    public val instanceIdentifiers: List<String>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.rds.kotlin.outputs.GetInstancesFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceArns = javaType.instanceArns().map({ args0 -> args0 }),
            instanceIdentifiers = javaType.instanceIdentifiers().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
