@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getParameterGroup.
 * @property arn ARN of the parameter group.
 * @property description Description of the parameter group.
 * @property family Family of the parameter group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 */
public data class GetParameterGroupResult(
    public val arn: String,
    public val description: String,
    public val family: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetParameterGroupResult): GetParameterGroupResult = GetParameterGroupResult(
            arn = javaType.arn(),
            description = javaType.description(),
            family = javaType.family(),
            id = javaType.id(),
            name = javaType.name(),
        )
    }
}
