@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProxy.
 * @property arn ARN of the DB Proxy.
 * @property auths Configuration(s) with authorization mechanisms to connect to the associated instance or cluster.
 * @property debugLogging Whether the proxy includes detailed information about SQL statements in its logs.
 * @property endpoint Endpoint that you can use to connect to the DB proxy.
 * @property engineFamily Kinds of databases that the proxy can connect to.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property idleClientTimeout Number of seconds a connection to the proxy can have no activity before the proxy drops the client connection.
 * @property name
 * @property requireTls Whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
 * @property roleArn ARN for the IAM role that the proxy uses to access Amazon Secrets Manager.
 * @property vpcId Provides the VPC ID of the DB proxy.
 * @property vpcSecurityGroupIds Provides a list of VPC security groups that the proxy belongs to.
 * @property vpcSubnetIds EC2 subnet IDs for the proxy.
 */
public data class GetProxyResult(
    public val arn: String,
    public val auths: List<GetProxyAuth>,
    public val debugLogging: Boolean,
    public val endpoint: String,
    public val engineFamily: String,
    public val id: String,
    public val idleClientTimeout: Int,
    public val name: String,
    public val requireTls: Boolean,
    public val roleArn: String,
    public val vpcId: String,
    public val vpcSecurityGroupIds: List<String>,
    public val vpcSubnetIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetProxyResult): GetProxyResult =
            GetProxyResult(
                arn = javaType.arn(),
                auths = javaType.auths().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.rds.kotlin.outputs.GetProxyAuth.Companion.toKotlin(args0)
                    })
                }),
                debugLogging = javaType.debugLogging(),
                endpoint = javaType.endpoint(),
                engineFamily = javaType.engineFamily(),
                id = javaType.id(),
                idleClientTimeout = javaType.idleClientTimeout(),
                name = javaType.name(),
                requireTls = javaType.requireTls(),
                roleArn = javaType.roleArn(),
                vpcId = javaType.vpcId(),
                vpcSecurityGroupIds = javaType.vpcSecurityGroupIds().map({ args0 -> args0 }),
                vpcSubnetIds = javaType.vpcSubnetIds().map({ args0 -> args0 }),
            )
    }
}
