@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getReservedInstanceOffering.
 * @property currencyCode Currency code for the reserved DB instance.
 * @property dbInstanceClass
 * @property duration
 * @property fixedPrice Fixed price charged for this reserved DB instance.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property multiAz
 * @property offeringId Unique identifier for the reservation.
 * @property offeringType
 * @property productDescription
 */
public data class GetReservedInstanceOfferingResult(
    public val currencyCode: String,
    public val dbInstanceClass: String,
    public val duration: Int,
    public val fixedPrice: Double,
    public val id: String,
    public val multiAz: Boolean,
    public val offeringId: String,
    public val offeringType: String,
    public val productDescription: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.GetReservedInstanceOfferingResult): GetReservedInstanceOfferingResult = GetReservedInstanceOfferingResult(
            currencyCode = javaType.currencyCode(),
            dbInstanceClass = javaType.dbInstanceClass(),
            duration = javaType.duration(),
            fixedPrice = javaType.fixedPrice(),
            id = javaType.id(),
            multiAz = javaType.multiAz(),
            offeringId = javaType.offeringId(),
            offeringType = javaType.offeringType(),
            productDescription = javaType.productDescription(),
        )
    }
}
