@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enabled Enables low-downtime updates when `true`.
 * Default is `false`.
 * [instance-replication]:
 * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Replication.html
 * [instance-maintenance]:
 * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html
 * [blue-green]:
 * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
 */
public data class InstanceBlueGreenUpdate(
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.InstanceBlueGreenUpdate): InstanceBlueGreenUpdate = InstanceBlueGreenUpdate(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
