@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address Specifies the DNS address of the DB instance.
 * @property hostedZoneId Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
 * @property port The port on which the DB accepts connections.
 */
public data class InstanceListenerEndpoint(
    public val address: String? = null,
    public val hostedZoneId: String? = null,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.InstanceListenerEndpoint): InstanceListenerEndpoint = InstanceListenerEndpoint(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            hostedZoneId = javaType.hostedZoneId().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
