@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId The ARN for the KMS encryption key. If creating an
 * encrypted replica, set this to the destination KMS ARN.
 * @property secretArn The Amazon Resource Name (ARN) of the secret.
 * @property secretStatus The status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
 */
public data class InstanceMasterUserSecret(
    public val kmsKeyId: String? = null,
    public val secretArn: String? = null,
    public val secretStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.InstanceMasterUserSecret): InstanceMasterUserSecret = InstanceMasterUserSecret(
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            secretArn = javaType.secretArn().map({ args0 -> args0 }).orElse(null),
            secretStatus = javaType.secretStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
