@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The bucket name where your backup is stored
 * @property bucketPrefix Can be blank, but is the path to your backup
 * @property ingestionRole Role applied to load the data.
 * @property sourceEngine Source engine for the backup
 * @property sourceEngineVersion Version of the source engine used to make the backup
 * This will not recreate the resource if the S3 object changes in some way.  It's only used to initialize the database.
 */
public data class InstanceS3Import(
    public val bucketName: String,
    public val bucketPrefix: String? = null,
    public val ingestionRole: String,
    public val sourceEngine: String,
    public val sourceEngineVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.InstanceS3Import): InstanceS3Import =
            InstanceS3Import(
                bucketName = javaType.bucketName(),
                bucketPrefix = javaType.bucketPrefix().map({ args0 -> args0 }).orElse(null),
                ingestionRole = javaType.ingestionRole(),
                sourceEngine = javaType.sourceEngine(),
                sourceEngineVersion = javaType.sourceEngineVersion(),
            )
    }
}
