@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionBorrowTimeout The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
 * @property initQuery One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
 * @property maxConnectionsPercent The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
 * @property maxIdleConnectionsPercent Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
 * @property sessionPinningFilters Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
 */
public data class ProxyDefaultTargetGroupConnectionPoolConfig(
    public val connectionBorrowTimeout: Int? = null,
    public val initQuery: String? = null,
    public val maxConnectionsPercent: Int? = null,
    public val maxIdleConnectionsPercent: Int? = null,
    public val sessionPinningFilters: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.ProxyDefaultTargetGroupConnectionPoolConfig): ProxyDefaultTargetGroupConnectionPoolConfig = ProxyDefaultTargetGroupConnectionPoolConfig(
            connectionBorrowTimeout = javaType.connectionBorrowTimeout().map({ args0 -> args0 }).orElse(null),
            initQuery = javaType.initQuery().map({ args0 -> args0 }).orElse(null),
            maxConnectionsPercent = javaType.maxConnectionsPercent().map({ args0 -> args0 }).orElse(null),
            maxIdleConnectionsPercent = javaType.maxIdleConnectionsPercent().map({ args0 ->
                args0
            }).orElse(null),
            sessionPinningFilters = javaType.sessionPinningFilters().map({ args0 -> args0 }),
        )
    }
}
