@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.kotlin.outputs.ClusterClusterNode
import com.pulumi.aws.redshift.kotlin.outputs.ClusterLogging
import com.pulumi.aws.redshift.kotlin.outputs.ClusterSnapshotCopy
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.redshift.kotlin.outputs.ClusterClusterNode.Companion.toKotlin as clusterClusterNodeToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.ClusterLogging.Companion.toKotlin as clusterLoggingToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.ClusterSnapshotCopy.Companion.toKotlin as clusterSnapshotCopyToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.aws.redshift.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Provides a Redshift Cluster Resource.
 * > **NOTE:** A Redshift cluster's default IAM role can be managed both by this resource's `default_iam_role_arn` argument and the `aws.redshift.ClusterIamRoles` resource's `default_iam_role_arn` argument. Do not configure different values for both arguments. Doing so will cause a conflict of default IAM roles.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.Cluster("example", {
 *     clusterIdentifier: "tf-redshift-cluster",
 *     databaseName: "mydb",
 *     masterUsername: "exampleuser",
 *     masterPassword: "Mustbe8characters",
 *     nodeType: "dc1.large",
 *     clusterType: "single-node",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.Cluster("example",
 *     cluster_identifier="tf-redshift-cluster",
 *     database_name="mydb",
 *     master_username="exampleuser",
 *     master_password="Mustbe8characters",
 *     node_type="dc1.large",
 *     cluster_type="single-node")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.Cluster("example", new()
 *     {
 *         ClusterIdentifier = "tf-redshift-cluster",
 *         DatabaseName = "mydb",
 *         MasterUsername = "exampleuser",
 *         MasterPassword = "Mustbe8characters",
 *         NodeType = "dc1.large",
 *         ClusterType = "single-node",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewCluster(ctx, "example", &redshift.ClusterArgs{
 * 			ClusterIdentifier: pulumi.String("tf-redshift-cluster"),
 * 			DatabaseName:      pulumi.String("mydb"),
 * 			MasterUsername:    pulumi.String("exampleuser"),
 * 			MasterPassword:    pulumi.String("Mustbe8characters"),
 * 			NodeType:          pulumi.String("dc1.large"),
 * 			ClusterType:       pulumi.String("single-node"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .clusterIdentifier("tf-redshift-cluster")
 *             .databaseName("mydb")
 *             .masterUsername("exampleuser")
 *             .masterPassword("Mustbe8characters")
 *             .nodeType("dc1.large")
 *             .clusterType("single-node")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:Cluster
 *     properties:
 *       clusterIdentifier: tf-redshift-cluster
 *       databaseName: mydb
 *       masterUsername: exampleuser
 *       masterPassword: Mustbe8characters
 *       nodeType: dc1.large
 *       clusterType: single-node
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Managed Credentials
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.Cluster("example", {
 *     clusterIdentifier: "tf-redshift-cluster",
 *     databaseName: "mydb",
 *     masterUsername: "exampleuser",
 *     nodeType: "dc1.large",
 *     clusterType: "single-node",
 *     manageMasterPassword: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.Cluster("example",
 *     cluster_identifier="tf-redshift-cluster",
 *     database_name="mydb",
 *     master_username="exampleuser",
 *     node_type="dc1.large",
 *     cluster_type="single-node",
 *     manage_master_password=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.Cluster("example", new()
 *     {
 *         ClusterIdentifier = "tf-redshift-cluster",
 *         DatabaseName = "mydb",
 *         MasterUsername = "exampleuser",
 *         NodeType = "dc1.large",
 *         ClusterType = "single-node",
 *         ManageMasterPassword = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewCluster(ctx, "example", &redshift.ClusterArgs{
 * 			ClusterIdentifier:    pulumi.String("tf-redshift-cluster"),
 * 			DatabaseName:         pulumi.String("mydb"),
 * 			MasterUsername:       pulumi.String("exampleuser"),
 * 			NodeType:             pulumi.String("dc1.large"),
 * 			ClusterType:          pulumi.String("single-node"),
 * 			ManageMasterPassword: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .clusterIdentifier("tf-redshift-cluster")
 *             .databaseName("mydb")
 *             .masterUsername("exampleuser")
 *             .nodeType("dc1.large")
 *             .clusterType("single-node")
 *             .manageMasterPassword(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:Cluster
 *     properties:
 *       clusterIdentifier: tf-redshift-cluster
 *       databaseName: mydb
 *       masterUsername: exampleuser
 *       nodeType: dc1.large
 *       clusterType: single-node
 *       manageMasterPassword: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Clusters using the `cluster_identifier`. For example:
 * ```sh
 * $ pulumi import aws:redshift/cluster:Cluster myprodcluster tf-redshift-cluster-12345
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.aws.redshift.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
     */
    public val allowVersionUpgrade: Output<Boolean>?
        get() = javaResource.allowVersionUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
     */
    public val applyImmediately: Output<Boolean>?
        get() = javaResource.applyImmediately().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
     * No longer supported by the AWS API.
     * Always returns `auto`.
     */
    @Deprecated(
        message = """
  This parameter is no longer supported by the AWS API. It will be removed in the next major version
      of the provider.
  """,
    )
    public val aquaConfigurationStatus: Output<String>
        get() = javaResource.aquaConfigurationStatus().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of cluster
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
     */
    public val automatedSnapshotRetentionPeriod: Output<Int>?
        get() = javaResource.automatedSnapshotRetentionPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
     */
    public val availabilityZoneRelocationEnabled: Output<Boolean>?
        get() = javaResource.availabilityZoneRelocationEnabled().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The Cluster Identifier. Must be a lower case string.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The namespace Amazon Resource Name (ARN) of the cluster
     */
    public val clusterNamespaceArn: Output<String>
        get() = javaResource.clusterNamespaceArn().applyValue({ args0 -> args0 })

    /**
     * The nodes in the cluster. Cluster node blocks are documented below
     */
    public val clusterNodes: Output<List<ClusterClusterNode>>
        get() = javaResource.clusterNodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterClusterNodeToKotlin(args0)
                })
            })
        })

    /**
     * The name of the parameter group to be associated with this cluster.
     */
    public val clusterParameterGroupName: Output<String>
        get() = javaResource.clusterParameterGroupName().applyValue({ args0 -> args0 })

    /**
     * The public key for the cluster
     */
    public val clusterPublicKey: Output<String>
        get() = javaResource.clusterPublicKey().applyValue({ args0 -> args0 })

    /**
     * The specific revision number of the database in the cluster
     */
    public val clusterRevisionNumber: Output<String>
        get() = javaResource.clusterRevisionNumber().applyValue({ args0 -> args0 })

    /**
     * The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
     */
    public val clusterSubnetGroupName: Output<String>
        get() = javaResource.clusterSubnetGroupName().applyValue({ args0 -> args0 })

    /**
     * The cluster type to use. Either `single-node` or `multi-node`.
     */
    public val clusterType: Output<String>
        get() = javaResource.clusterType().applyValue({ args0 -> args0 })

    /**
     * The version of the Amazon Redshift engine software that you want to deploy on the cluster.
     * The version selected runs on all the nodes in the cluster.
     */
    public val clusterVersion: Output<String>?
        get() = javaResource.clusterVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the first database to be created when the cluster is created.
     * If you do not provide a name, Amazon Redshift will create a default database called `dev`.
     */
    public val databaseName: Output<String>
        get() = javaResource.databaseName().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
     */
    public val defaultIamRoleArn: Output<String>
        get() = javaResource.defaultIamRoleArn().applyValue({ args0 -> args0 })

    /**
     * The DNS name of the cluster
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * The Elastic IP (EIP) address for the cluster.
     */
    public val elasticIp: Output<String>?
        get() = javaResource.elasticIp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If true , the data in the cluster is encrypted at rest.
     */
    public val encrypted: Output<Boolean>?
        get() = javaResource.encrypted().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The connection endpoint
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * If true , enhanced VPC routing is enabled.
     */
    public val enhancedVpcRouting: Output<Boolean>
        get() = javaResource.enhancedVpcRouting().applyValue({ args0 -> args0 })

    /**
     * The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
     */
    public val finalSnapshotIdentifier: Output<String>?
        get() = javaResource.finalSnapshotIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     */
    public val iamRoles: Output<List<String>>
        get() = javaResource.iamRoles().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Logging, documented below.
     */
    @Deprecated(
        message = """
  Use the aws.redshift.Logging resource instead. This argument will be removed in a future major
      version.
  """,
    )
    public val logging: Output<ClusterLogging>
        get() = javaResource.logging().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterLoggingToKotlin(args0)
            })
        })

    /**
     * The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
     */
    public val maintenanceTrackName: Output<String>?
        get() = javaResource.maintenanceTrackName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to use AWS SecretsManager to manage the cluster admin credentials.
     * Conflicts with `master_password`.
     * One of `master_password` or `manage_master_password` is required unless `snapshot_identifier` is provided.
     */
    public val manageMasterPassword: Output<Boolean>?
        get() = javaResource.manageMasterPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
     */
    public val manualSnapshotRetentionPeriod: Output<Int>?
        get() = javaResource.manualSnapshotRetentionPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Password for the master DB user.
     * Conflicts with `manage_master_password`.
     * One of `master_password` or `manage_master_password` is required unless `snapshot_identifier` is provided.
     * Note that this may show up in logs, and it will be stored in the state file.
     * Password must contain at least 8 characters and contain at least one uppercase letter, one lowercase letter, and one number.
     */
    public val masterPassword: Output<String>?
        get() = javaResource.masterPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the cluster admin credentials secret
     */
    public val masterPasswordSecretArn: Output<String>
        get() = javaResource.masterPasswordSecretArn().applyValue({ args0 -> args0 })

    /**
     * ID of the KMS key used to encrypt the cluster admin credentials secret.
     */
    public val masterPasswordSecretKmsKeyId: Output<String>
        get() = javaResource.masterPasswordSecretKmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Username for the master DB user.
     */
    public val masterUsername: Output<String>?
        get() = javaResource.masterUsername().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies if the Redshift cluster is multi-AZ.
     */
    public val multiAz: Output<Boolean>?
        get() = javaResource.multiAz().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The node type to be provisioned for the cluster.
     */
    public val nodeType: Output<String>
        get() = javaResource.nodeType().applyValue({ args0 -> args0 })

    /**
     * The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
     */
    public val numberOfNodes: Output<Int>?
        get() = javaResource.numberOfNodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
     */
    public val ownerAccount: Output<String>?
        get() = javaResource.ownerAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
     * The cluster is accessible only via the JDBC and ODBC connection strings.
     * Part of the connection string requires the port on which the cluster will listen for incoming connections.
     * Default port is `5439`.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The weekly time range (in UTC) during which automated cluster maintenance can occur.
     * Format: ddd:hh24:mi-ddd:hh24:mi
     */
    public val preferredMaintenanceWindow: Output<String>
        get() = javaResource.preferredMaintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * If true, the cluster can be accessed from a public network. Default is `true`.
     */
    public val publiclyAccessible: Output<Boolean>?
        get() = javaResource.publiclyAccessible().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
     */
    public val skipFinalSnapshot: Output<Boolean>?
        get() = javaResource.skipFinalSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the snapshot from which to create the new cluster. Conflicts with `snapshot_identifier`.
     */
    public val snapshotArn: Output<String>?
        get() = javaResource.snapshotArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the cluster the source snapshot was created from.
     */
    public val snapshotClusterIdentifier: Output<String>?
        get() = javaResource.snapshotClusterIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration of automatic copy of snapshots from one region to another. Documented below.
     */
    @Deprecated(
        message = """
  Use the aws.redshift.SnapshotCopy resource instead. This argument will be removed in a future
      major version.
  """,
    )
    public val snapshotCopy: Output<ClusterSnapshotCopy>
        get() = javaResource.snapshotCopy().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterSnapshotCopyToKotlin(args0)
            })
        })

    /**
     * The name of the snapshot from which to create the new cluster.  Conflicts with `snapshot_arn`.
     */
    public val snapshotIdentifier: Output<String>?
        get() = javaResource.snapshotIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.aws.redshift.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
