@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.ClusterArgs.builder
import com.pulumi.aws.redshift.kotlin.inputs.ClusterLoggingArgs
import com.pulumi.aws.redshift.kotlin.inputs.ClusterLoggingArgsBuilder
import com.pulumi.aws.redshift.kotlin.inputs.ClusterSnapshotCopyArgs
import com.pulumi.aws.redshift.kotlin.inputs.ClusterSnapshotCopyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Redshift Cluster Resource.
 * > **NOTE:** A Redshift cluster's default IAM role can be managed both by this resource's `default_iam_role_arn` argument and the `aws.redshift.ClusterIamRoles` resource's `default_iam_role_arn` argument. Do not configure different values for both arguments. Doing so will cause a conflict of default IAM roles.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.Cluster("example", {
 *     clusterIdentifier: "tf-redshift-cluster",
 *     databaseName: "mydb",
 *     masterUsername: "exampleuser",
 *     masterPassword: "Mustbe8characters",
 *     nodeType: "dc1.large",
 *     clusterType: "single-node",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.Cluster("example",
 *     cluster_identifier="tf-redshift-cluster",
 *     database_name="mydb",
 *     master_username="exampleuser",
 *     master_password="Mustbe8characters",
 *     node_type="dc1.large",
 *     cluster_type="single-node")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.Cluster("example", new()
 *     {
 *         ClusterIdentifier = "tf-redshift-cluster",
 *         DatabaseName = "mydb",
 *         MasterUsername = "exampleuser",
 *         MasterPassword = "Mustbe8characters",
 *         NodeType = "dc1.large",
 *         ClusterType = "single-node",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewCluster(ctx, "example", &redshift.ClusterArgs{
 * 			ClusterIdentifier: pulumi.String("tf-redshift-cluster"),
 * 			DatabaseName:      pulumi.String("mydb"),
 * 			MasterUsername:    pulumi.String("exampleuser"),
 * 			MasterPassword:    pulumi.String("Mustbe8characters"),
 * 			NodeType:          pulumi.String("dc1.large"),
 * 			ClusterType:       pulumi.String("single-node"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .clusterIdentifier("tf-redshift-cluster")
 *             .databaseName("mydb")
 *             .masterUsername("exampleuser")
 *             .masterPassword("Mustbe8characters")
 *             .nodeType("dc1.large")
 *             .clusterType("single-node")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:Cluster
 *     properties:
 *       clusterIdentifier: tf-redshift-cluster
 *       databaseName: mydb
 *       masterUsername: exampleuser
 *       masterPassword: Mustbe8characters
 *       nodeType: dc1.large
 *       clusterType: single-node
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Managed Credentials
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.Cluster("example", {
 *     clusterIdentifier: "tf-redshift-cluster",
 *     databaseName: "mydb",
 *     masterUsername: "exampleuser",
 *     nodeType: "dc1.large",
 *     clusterType: "single-node",
 *     manageMasterPassword: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.Cluster("example",
 *     cluster_identifier="tf-redshift-cluster",
 *     database_name="mydb",
 *     master_username="exampleuser",
 *     node_type="dc1.large",
 *     cluster_type="single-node",
 *     manage_master_password=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.Cluster("example", new()
 *     {
 *         ClusterIdentifier = "tf-redshift-cluster",
 *         DatabaseName = "mydb",
 *         MasterUsername = "exampleuser",
 *         NodeType = "dc1.large",
 *         ClusterType = "single-node",
 *         ManageMasterPassword = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewCluster(ctx, "example", &redshift.ClusterArgs{
 * 			ClusterIdentifier:    pulumi.String("tf-redshift-cluster"),
 * 			DatabaseName:         pulumi.String("mydb"),
 * 			MasterUsername:       pulumi.String("exampleuser"),
 * 			NodeType:             pulumi.String("dc1.large"),
 * 			ClusterType:          pulumi.String("single-node"),
 * 			ManageMasterPassword: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .clusterIdentifier("tf-redshift-cluster")
 *             .databaseName("mydb")
 *             .masterUsername("exampleuser")
 *             .nodeType("dc1.large")
 *             .clusterType("single-node")
 *             .manageMasterPassword(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:Cluster
 *     properties:
 *       clusterIdentifier: tf-redshift-cluster
 *       databaseName: mydb
 *       masterUsername: exampleuser
 *       nodeType: dc1.large
 *       clusterType: single-node
 *       manageMasterPassword: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Clusters using the `cluster_identifier`. For example:
 * ```sh
 * $ pulumi import aws:redshift/cluster:Cluster myprodcluster tf-redshift-cluster-12345
 * ```
 * @property allowVersionUpgrade If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
 * @property applyImmediately Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
 * @property aquaConfigurationStatus The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
 * No longer supported by the AWS API.
 * Always returns `auto`.
 * @property automatedSnapshotRetentionPeriod The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
 * @property availabilityZone The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
 * @property availabilityZoneRelocationEnabled If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
 * @property clusterIdentifier The Cluster Identifier. Must be a lower case string.
 * @property clusterParameterGroupName The name of the parameter group to be associated with this cluster.
 * @property clusterPublicKey The public key for the cluster
 * @property clusterRevisionNumber The specific revision number of the database in the cluster
 * @property clusterSubnetGroupName The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
 * @property clusterType The cluster type to use. Either `single-node` or `multi-node`.
 * @property clusterVersion The version of the Amazon Redshift engine software that you want to deploy on the cluster.
 * The version selected runs on all the nodes in the cluster.
 * @property databaseName The name of the first database to be created when the cluster is created.
 * If you do not provide a name, Amazon Redshift will create a default database called `dev`.
 * @property defaultIamRoleArn The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
 * @property elasticIp The Elastic IP (EIP) address for the cluster.
 * @property encrypted If true , the data in the cluster is encrypted at rest.
 * @property endpoint The connection endpoint
 * @property enhancedVpcRouting If true , enhanced VPC routing is enabled.
 * @property finalSnapshotIdentifier The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
 * @property iamRoles A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
 * @property kmsKeyId The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
 * @property logging Logging, documented below.
 * @property maintenanceTrackName The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
 * @property manageMasterPassword Whether to use AWS SecretsManager to manage the cluster admin credentials.
 * Conflicts with `master_password`.
 * One of `master_password` or `manage_master_password` is required unless `snapshot_identifier` is provided.
 * @property manualSnapshotRetentionPeriod The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
 * @property masterPassword Password for the master DB user.
 * Conflicts with `manage_master_password`.
 * One of `master_password` or `manage_master_password` is required unless `snapshot_identifier` is provided.
 * Note that this may show up in logs, and it will be stored in the state file.
 * Password must contain at least 8 characters and contain at least one uppercase letter, one lowercase letter, and one number.
 * @property masterPasswordSecretKmsKeyId ID of the KMS key used to encrypt the cluster admin credentials secret.
 * @property masterUsername Username for the master DB user.
 * @property multiAz Specifies if the Redshift cluster is multi-AZ.
 * @property nodeType The node type to be provisioned for the cluster.
 * @property numberOfNodes The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
 * @property ownerAccount The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
 * @property port The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
 * The cluster is accessible only via the JDBC and ODBC connection strings.
 * Part of the connection string requires the port on which the cluster will listen for incoming connections.
 * Default port is `5439`.
 * @property preferredMaintenanceWindow The weekly time range (in UTC) during which automated cluster maintenance can occur.
 * Format: ddd:hh24:mi-ddd:hh24:mi
 * @property publiclyAccessible If true, the cluster can be accessed from a public network. Default is `true`.
 * @property skipFinalSnapshot Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
 * @property snapshotArn The ARN of the snapshot from which to create the new cluster. Conflicts with `snapshot_identifier`.
 * @property snapshotClusterIdentifier The name of the cluster the source snapshot was created from.
 * @property snapshotCopy Configuration of automatic copy of snapshots from one region to another. Documented below.
 * @property snapshotIdentifier The name of the snapshot from which to create the new cluster.  Conflicts with `snapshot_arn`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcSecurityGroupIds A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
 */
public data class ClusterArgs(
    public val allowVersionUpgrade: Output<Boolean>? = null,
    public val applyImmediately: Output<Boolean>? = null,
    @Deprecated(
        message = """
  This parameter is no longer supported by the AWS API. It will be removed in the next major version
      of the provider.
  """,
    )
    public val aquaConfigurationStatus: Output<String>? = null,
    public val automatedSnapshotRetentionPeriod: Output<Int>? = null,
    public val availabilityZone: Output<String>? = null,
    public val availabilityZoneRelocationEnabled: Output<Boolean>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val clusterParameterGroupName: Output<String>? = null,
    public val clusterPublicKey: Output<String>? = null,
    public val clusterRevisionNumber: Output<String>? = null,
    public val clusterSubnetGroupName: Output<String>? = null,
    public val clusterType: Output<String>? = null,
    public val clusterVersion: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val defaultIamRoleArn: Output<String>? = null,
    public val elasticIp: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val endpoint: Output<String>? = null,
    public val enhancedVpcRouting: Output<Boolean>? = null,
    public val finalSnapshotIdentifier: Output<String>? = null,
    public val iamRoles: Output<List<String>>? = null,
    public val kmsKeyId: Output<String>? = null,
    @Deprecated(
        message = """
  Use the aws.redshift.Logging resource instead. This argument will be removed in a future major
      version.
  """,
    )
    public val logging: Output<ClusterLoggingArgs>? = null,
    public val maintenanceTrackName: Output<String>? = null,
    public val manageMasterPassword: Output<Boolean>? = null,
    public val manualSnapshotRetentionPeriod: Output<Int>? = null,
    public val masterPassword: Output<String>? = null,
    public val masterPasswordSecretKmsKeyId: Output<String>? = null,
    public val masterUsername: Output<String>? = null,
    public val multiAz: Output<Boolean>? = null,
    public val nodeType: Output<String>? = null,
    public val numberOfNodes: Output<Int>? = null,
    public val ownerAccount: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val preferredMaintenanceWindow: Output<String>? = null,
    public val publiclyAccessible: Output<Boolean>? = null,
    public val skipFinalSnapshot: Output<Boolean>? = null,
    public val snapshotArn: Output<String>? = null,
    public val snapshotClusterIdentifier: Output<String>? = null,
    @Deprecated(
        message = """
  Use the aws.redshift.SnapshotCopy resource instead. This argument will be removed in a future
      major version.
  """,
    )
    public val snapshotCopy: Output<ClusterSnapshotCopyArgs>? = null,
    public val snapshotIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.redshift.ClusterArgs =
        com.pulumi.aws.redshift.ClusterArgs.builder()
            .allowVersionUpgrade(allowVersionUpgrade?.applyValue({ args0 -> args0 }))
            .applyImmediately(applyImmediately?.applyValue({ args0 -> args0 }))
            .aquaConfigurationStatus(aquaConfigurationStatus?.applyValue({ args0 -> args0 }))
            .automatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .availabilityZoneRelocationEnabled(
                availabilityZoneRelocationEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .clusterParameterGroupName(clusterParameterGroupName?.applyValue({ args0 -> args0 }))
            .clusterPublicKey(clusterPublicKey?.applyValue({ args0 -> args0 }))
            .clusterRevisionNumber(clusterRevisionNumber?.applyValue({ args0 -> args0 }))
            .clusterSubnetGroupName(clusterSubnetGroupName?.applyValue({ args0 -> args0 }))
            .clusterType(clusterType?.applyValue({ args0 -> args0 }))
            .clusterVersion(clusterVersion?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .defaultIamRoleArn(defaultIamRoleArn?.applyValue({ args0 -> args0 }))
            .elasticIp(elasticIp?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .enhancedVpcRouting(enhancedVpcRouting?.applyValue({ args0 -> args0 }))
            .finalSnapshotIdentifier(finalSnapshotIdentifier?.applyValue({ args0 -> args0 }))
            .iamRoles(iamRoles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .logging(logging?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maintenanceTrackName(maintenanceTrackName?.applyValue({ args0 -> args0 }))
            .manageMasterPassword(manageMasterPassword?.applyValue({ args0 -> args0 }))
            .manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod?.applyValue({ args0 -> args0 }))
            .masterPassword(masterPassword?.applyValue({ args0 -> args0 }))
            .masterPasswordSecretKmsKeyId(masterPasswordSecretKmsKeyId?.applyValue({ args0 -> args0 }))
            .masterUsername(masterUsername?.applyValue({ args0 -> args0 }))
            .multiAz(multiAz?.applyValue({ args0 -> args0 }))
            .nodeType(nodeType?.applyValue({ args0 -> args0 }))
            .numberOfNodes(numberOfNodes?.applyValue({ args0 -> args0 }))
            .ownerAccount(ownerAccount?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .preferredMaintenanceWindow(preferredMaintenanceWindow?.applyValue({ args0 -> args0 }))
            .publiclyAccessible(publiclyAccessible?.applyValue({ args0 -> args0 }))
            .skipFinalSnapshot(skipFinalSnapshot?.applyValue({ args0 -> args0 }))
            .snapshotArn(snapshotArn?.applyValue({ args0 -> args0 }))
            .snapshotClusterIdentifier(snapshotClusterIdentifier?.applyValue({ args0 -> args0 }))
            .snapshotCopy(snapshotCopy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snapshotIdentifier(snapshotIdentifier?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcSecurityGroupIds(
                vpcSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var allowVersionUpgrade: Output<Boolean>? = null

    private var applyImmediately: Output<Boolean>? = null

    private var aquaConfigurationStatus: Output<String>? = null

    private var automatedSnapshotRetentionPeriod: Output<Int>? = null

    private var availabilityZone: Output<String>? = null

    private var availabilityZoneRelocationEnabled: Output<Boolean>? = null

    private var clusterIdentifier: Output<String>? = null

    private var clusterParameterGroupName: Output<String>? = null

    private var clusterPublicKey: Output<String>? = null

    private var clusterRevisionNumber: Output<String>? = null

    private var clusterSubnetGroupName: Output<String>? = null

    private var clusterType: Output<String>? = null

    private var clusterVersion: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var defaultIamRoleArn: Output<String>? = null

    private var elasticIp: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var endpoint: Output<String>? = null

    private var enhancedVpcRouting: Output<Boolean>? = null

    private var finalSnapshotIdentifier: Output<String>? = null

    private var iamRoles: Output<List<String>>? = null

    private var kmsKeyId: Output<String>? = null

    private var logging: Output<ClusterLoggingArgs>? = null

    private var maintenanceTrackName: Output<String>? = null

    private var manageMasterPassword: Output<Boolean>? = null

    private var manualSnapshotRetentionPeriod: Output<Int>? = null

    private var masterPassword: Output<String>? = null

    private var masterPasswordSecretKmsKeyId: Output<String>? = null

    private var masterUsername: Output<String>? = null

    private var multiAz: Output<Boolean>? = null

    private var nodeType: Output<String>? = null

    private var numberOfNodes: Output<Int>? = null

    private var ownerAccount: Output<String>? = null

    private var port: Output<Int>? = null

    private var preferredMaintenanceWindow: Output<String>? = null

    private var publiclyAccessible: Output<Boolean>? = null

    private var skipFinalSnapshot: Output<Boolean>? = null

    private var snapshotArn: Output<String>? = null

    private var snapshotClusterIdentifier: Output<String>? = null

    private var snapshotCopy: Output<ClusterSnapshotCopyArgs>? = null

    private var snapshotIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    /**
     * @param value If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
     */
    @JvmName("kxtovejgkviavqly")
    public suspend fun allowVersionUpgrade(`value`: Output<Boolean>) {
        this.allowVersionUpgrade = value
    }

    /**
     * @param value Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
     */
    @JvmName("yidbcvlxfjpxydjh")
    public suspend fun applyImmediately(`value`: Output<Boolean>) {
        this.applyImmediately = value
    }

    /**
     * @param value The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
     * No longer supported by the AWS API.
     * Always returns `auto`.
     */
    @Deprecated(
        message = """
  This parameter is no longer supported by the AWS API. It will be removed in the next major version
      of the provider.
  """,
    )
    @JvmName("bojbaxecbhmiejsi")
    public suspend fun aquaConfigurationStatus(`value`: Output<String>) {
        this.aquaConfigurationStatus = value
    }

    /**
     * @param value The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
     */
    @JvmName("mbktxaeuomfgfdxx")
    public suspend fun automatedSnapshotRetentionPeriod(`value`: Output<Int>) {
        this.automatedSnapshotRetentionPeriod = value
    }

    /**
     * @param value The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
     */
    @JvmName("kqwprgqivleuacxq")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
     */
    @JvmName("ubyvkrnjhhhkagtw")
    public suspend fun availabilityZoneRelocationEnabled(`value`: Output<Boolean>) {
        this.availabilityZoneRelocationEnabled = value
    }

    /**
     * @param value The Cluster Identifier. Must be a lower case string.
     */
    @JvmName("xuludmncygixgugy")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The name of the parameter group to be associated with this cluster.
     */
    @JvmName("dvajvseuemwgnoyf")
    public suspend fun clusterParameterGroupName(`value`: Output<String>) {
        this.clusterParameterGroupName = value
    }

    /**
     * @param value The public key for the cluster
     */
    @JvmName("cojhcrkpmuquufoq")
    public suspend fun clusterPublicKey(`value`: Output<String>) {
        this.clusterPublicKey = value
    }

    /**
     * @param value The specific revision number of the database in the cluster
     */
    @JvmName("hlfvijgtnqwrdnvx")
    public suspend fun clusterRevisionNumber(`value`: Output<String>) {
        this.clusterRevisionNumber = value
    }

    /**
     * @param value The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
     */
    @JvmName("axtvxourbitgigjj")
    public suspend fun clusterSubnetGroupName(`value`: Output<String>) {
        this.clusterSubnetGroupName = value
    }

    /**
     * @param value The cluster type to use. Either `single-node` or `multi-node`.
     */
    @JvmName("qyeiylbbpkfbeyxy")
    public suspend fun clusterType(`value`: Output<String>) {
        this.clusterType = value
    }

    /**
     * @param value The version of the Amazon Redshift engine software that you want to deploy on the cluster.
     * The version selected runs on all the nodes in the cluster.
     */
    @JvmName("hrubkqhivjvfkext")
    public suspend fun clusterVersion(`value`: Output<String>) {
        this.clusterVersion = value
    }

    /**
     * @param value The name of the first database to be created when the cluster is created.
     * If you do not provide a name, Amazon Redshift will create a default database called `dev`.
     */
    @JvmName("cguyqdlxkyvyqoxn")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
     */
    @JvmName("veeiueghctwciowo")
    public suspend fun defaultIamRoleArn(`value`: Output<String>) {
        this.defaultIamRoleArn = value
    }

    /**
     * @param value The Elastic IP (EIP) address for the cluster.
     */
    @JvmName("jfaupbvvutumdcir")
    public suspend fun elasticIp(`value`: Output<String>) {
        this.elasticIp = value
    }

    /**
     * @param value If true , the data in the cluster is encrypted at rest.
     */
    @JvmName("iukutanhucddljli")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The connection endpoint
     */
    @JvmName("yiwaiedmmsxtiiox")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value If true , enhanced VPC routing is enabled.
     */
    @JvmName("jjasjlypxrtxsvhl")
    public suspend fun enhancedVpcRouting(`value`: Output<Boolean>) {
        this.enhancedVpcRouting = value
    }

    /**
     * @param value The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
     */
    @JvmName("qmhyhydflgoohgxw")
    public suspend fun finalSnapshotIdentifier(`value`: Output<String>) {
        this.finalSnapshotIdentifier = value
    }

    /**
     * @param value A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     */
    @JvmName("ymjeapocwlnebxyj")
    public suspend fun iamRoles(`value`: Output<List<String>>) {
        this.iamRoles = value
    }

    @JvmName("bukiiivefjtkletx")
    public suspend fun iamRoles(vararg values: Output<String>) {
        this.iamRoles = Output.all(values.asList())
    }

    /**
     * @param values A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     */
    @JvmName("radtenoikxnqjwmc")
    public suspend fun iamRoles(values: List<Output<String>>) {
        this.iamRoles = Output.all(values)
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
     */
    @JvmName("beqlrfcaqnjutgct")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Logging, documented below.
     */
    @Deprecated(
        message = """
  Use the aws.redshift.Logging resource instead. This argument will be removed in a future major
      version.
  """,
    )
    @JvmName("syeoetuoajwbcmik")
    public suspend fun logging(`value`: Output<ClusterLoggingArgs>) {
        this.logging = value
    }

    /**
     * @param value The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
     */
    @JvmName("uyspampwwikonhaw")
    public suspend fun maintenanceTrackName(`value`: Output<String>) {
        this.maintenanceTrackName = value
    }

    /**
     * @param value Whether to use AWS SecretsManager to manage the cluster admin credentials.
     * Conflicts with `master_password`.
     * One of `master_password` or `manage_master_password` is required unless `snapshot_identifier` is provided.
     */
    @JvmName("vxwuohohmesyddvw")
    public suspend fun manageMasterPassword(`value`: Output<Boolean>) {
        this.manageMasterPassword = value
    }

    /**
     * @param value The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
     */
    @JvmName("gcrmvorbxfrwlvbu")
    public suspend fun manualSnapshotRetentionPeriod(`value`: Output<Int>) {
        this.manualSnapshotRetentionPeriod = value
    }

    /**
     * @param value Password for the master DB user.
     * Conflicts with `manage_master_password`.
     * One of `master_password` or `manage_master_password` is required unless `snapshot_identifier` is provided.
     * Note that this may show up in logs, and it will be stored in the state file.
     * Password must contain at least 8 characters and contain at least one uppercase letter, one lowercase letter, and one number.
     */
    @JvmName("msmwinfaarvfetsa")
    public suspend fun masterPassword(`value`: Output<String>) {
        this.masterPassword = value
    }

    /**
     * @param value ID of the KMS key used to encrypt the cluster admin credentials secret.
     */
    @JvmName("kktbcvimqbvifbsd")
    public suspend fun masterPasswordSecretKmsKeyId(`value`: Output<String>) {
        this.masterPasswordSecretKmsKeyId = value
    }

    /**
     * @param value Username for the master DB user.
     */
    @JvmName("nwwouxgybdhmmnaa")
    public suspend fun masterUsername(`value`: Output<String>) {
        this.masterUsername = value
    }

    /**
     * @param value Specifies if the Redshift cluster is multi-AZ.
     */
    @JvmName("cefoflhcmikprspf")
    public suspend fun multiAz(`value`: Output<Boolean>) {
        this.multiAz = value
    }

    /**
     * @param value The node type to be provisioned for the cluster.
     */
    @JvmName("bbpcexosfhurtixg")
    public suspend fun nodeType(`value`: Output<String>) {
        this.nodeType = value
    }

    /**
     * @param value The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
     */
    @JvmName("xphjhqyxgufkxpcl")
    public suspend fun numberOfNodes(`value`: Output<Int>) {
        this.numberOfNodes = value
    }

    /**
     * @param value The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
     */
    @JvmName("ihjlaxqcjqyvbkwx")
    public suspend fun ownerAccount(`value`: Output<String>) {
        this.ownerAccount = value
    }

    /**
     * @param value The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
     * The cluster is accessible only via the JDBC and ODBC connection strings.
     * Part of the connection string requires the port on which the cluster will listen for incoming connections.
     * Default port is `5439`.
     */
    @JvmName("mjclgmayqsfajajj")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The weekly time range (in UTC) during which automated cluster maintenance can occur.
     * Format: ddd:hh24:mi-ddd:hh24:mi
     */
    @JvmName("dfxaqmjvauinwlsn")
    public suspend fun preferredMaintenanceWindow(`value`: Output<String>) {
        this.preferredMaintenanceWindow = value
    }

    /**
     * @param value If true, the cluster can be accessed from a public network. Default is `true`.
     */
    @JvmName("kmfvuthjbbggrncb")
    public suspend fun publiclyAccessible(`value`: Output<Boolean>) {
        this.publiclyAccessible = value
    }

    /**
     * @param value Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
     */
    @JvmName("iwuhobxrgoerdmwb")
    public suspend fun skipFinalSnapshot(`value`: Output<Boolean>) {
        this.skipFinalSnapshot = value
    }

    /**
     * @param value The ARN of the snapshot from which to create the new cluster. Conflicts with `snapshot_identifier`.
     */
    @JvmName("ixgblomhkevhtxcm")
    public suspend fun snapshotArn(`value`: Output<String>) {
        this.snapshotArn = value
    }

    /**
     * @param value The name of the cluster the source snapshot was created from.
     */
    @JvmName("kcvmairneoxttagv")
    public suspend fun snapshotClusterIdentifier(`value`: Output<String>) {
        this.snapshotClusterIdentifier = value
    }

    /**
     * @param value Configuration of automatic copy of snapshots from one region to another. Documented below.
     */
    @Deprecated(
        message = """
  Use the aws.redshift.SnapshotCopy resource instead. This argument will be removed in a future
      major version.
  """,
    )
    @JvmName("nyoldbfgcwtxdidh")
    public suspend fun snapshotCopy(`value`: Output<ClusterSnapshotCopyArgs>) {
        this.snapshotCopy = value
    }

    /**
     * @param value The name of the snapshot from which to create the new cluster.  Conflicts with `snapshot_arn`.
     */
    @JvmName("mboaedibdqydxhgi")
    public suspend fun snapshotIdentifier(`value`: Output<String>) {
        this.snapshotIdentifier = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("batgdyqxuvqqhauh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     */
    @JvmName("hjqouqrrngclholp")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("jyxyroaquytlmaiw")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     */
    @JvmName("kiqkidyntpoquvgx")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
     */
    @JvmName("prgmcucwpuwrkpwa")
    public suspend fun allowVersionUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowVersionUpgrade = mapped
    }

    /**
     * @param value Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
     */
    @JvmName("frgasvihuvjjhbbv")
    public suspend fun applyImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyImmediately = mapped
    }

    /**
     * @param value The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
     * No longer supported by the AWS API.
     * Always returns `auto`.
     */
    @Deprecated(
        message = """
  This parameter is no longer supported by the AWS API. It will be removed in the next major version
      of the provider.
  """,
    )
    @JvmName("xsytdbidfxxntruv")
    public suspend fun aquaConfigurationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aquaConfigurationStatus = mapped
    }

    /**
     * @param value The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
     */
    @JvmName("aubktqbjhsekdqpb")
    public suspend fun automatedSnapshotRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automatedSnapshotRetentionPeriod = mapped
    }

    /**
     * @param value The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
     */
    @JvmName("pcjtyhmbmefjyrhr")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
     */
    @JvmName("gowhkfdjvvlccgfk")
    public suspend fun availabilityZoneRelocationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZoneRelocationEnabled = mapped
    }

    /**
     * @param value The Cluster Identifier. Must be a lower case string.
     */
    @JvmName("nlfoeiixhvibsnob")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The name of the parameter group to be associated with this cluster.
     */
    @JvmName("nhnfkbychyqbtwgj")
    public suspend fun clusterParameterGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterParameterGroupName = mapped
    }

    /**
     * @param value The public key for the cluster
     */
    @JvmName("oophywhjywpvdoib")
    public suspend fun clusterPublicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterPublicKey = mapped
    }

    /**
     * @param value The specific revision number of the database in the cluster
     */
    @JvmName("aglloktikjsdpvje")
    public suspend fun clusterRevisionNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterRevisionNumber = mapped
    }

    /**
     * @param value The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
     */
    @JvmName("iqchxsijswdaqyaq")
    public suspend fun clusterSubnetGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSubnetGroupName = mapped
    }

    /**
     * @param value The cluster type to use. Either `single-node` or `multi-node`.
     */
    @JvmName("cclvaykxxmlnkthn")
    public suspend fun clusterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterType = mapped
    }

    /**
     * @param value The version of the Amazon Redshift engine software that you want to deploy on the cluster.
     * The version selected runs on all the nodes in the cluster.
     */
    @JvmName("cfsbffstsgdujdpk")
    public suspend fun clusterVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterVersion = mapped
    }

    /**
     * @param value The name of the first database to be created when the cluster is created.
     * If you do not provide a name, Amazon Redshift will create a default database called `dev`.
     */
    @JvmName("erjkrxostntbutel")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
     */
    @JvmName("jgnhgylelubgwlvb")
    public suspend fun defaultIamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultIamRoleArn = mapped
    }

    /**
     * @param value The Elastic IP (EIP) address for the cluster.
     */
    @JvmName("xbkwwfnsrrvrnjab")
    public suspend fun elasticIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticIp = mapped
    }

    /**
     * @param value If true , the data in the cluster is encrypted at rest.
     */
    @JvmName("obqxtwdcftacrpsy")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The connection endpoint
     */
    @JvmName("ixiwhbmfciflkyuj")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value If true , enhanced VPC routing is enabled.
     */
    @JvmName("btlmeekyqrltavoo")
    public suspend fun enhancedVpcRouting(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enhancedVpcRouting = mapped
    }

    /**
     * @param value The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
     */
    @JvmName("regdnfcyjhhwicct")
    public suspend fun finalSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finalSnapshotIdentifier = mapped
    }

    /**
     * @param value A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     */
    @JvmName("mlheopvuiyriqsfg")
    public suspend fun iamRoles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoles = mapped
    }

    /**
     * @param values A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     */
    @JvmName("pwhwccvqrwypsxri")
    public suspend fun iamRoles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iamRoles = mapped
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
     */
    @JvmName("rnwveplgalasdcwd")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Logging, documented below.
     */
    @Deprecated(
        message = """
  Use the aws.redshift.Logging resource instead. This argument will be removed in a future major
      version.
  """,
    )
    @JvmName("urimgipknkiqmbcd")
    public suspend fun logging(`value`: ClusterLoggingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logging = mapped
    }

    /**
     * @param argument Logging, documented below.
     */
    @Deprecated(
        message = """
  Use the aws.redshift.Logging resource instead. This argument will be removed in a future major
      version.
  """,
    )
    @JvmName("ynjakuxjjogrliho")
    public suspend fun logging(argument: suspend ClusterLoggingArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterLoggingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logging = mapped
    }

    /**
     * @param value The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
     */
    @JvmName("vitccicvguydywfu")
    public suspend fun maintenanceTrackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceTrackName = mapped
    }

    /**
     * @param value Whether to use AWS SecretsManager to manage the cluster admin credentials.
     * Conflicts with `master_password`.
     * One of `master_password` or `manage_master_password` is required unless `snapshot_identifier` is provided.
     */
    @JvmName("svorgasgdceoqnvq")
    public suspend fun manageMasterPassword(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manageMasterPassword = mapped
    }

    /**
     * @param value The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
     */
    @JvmName("umhqtochkijkpgid")
    public suspend fun manualSnapshotRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manualSnapshotRetentionPeriod = mapped
    }

    /**
     * @param value Password for the master DB user.
     * Conflicts with `manage_master_password`.
     * One of `master_password` or `manage_master_password` is required unless `snapshot_identifier` is provided.
     * Note that this may show up in logs, and it will be stored in the state file.
     * Password must contain at least 8 characters and contain at least one uppercase letter, one lowercase letter, and one number.
     */
    @JvmName("mdvkxkvtrtdjdkgj")
    public suspend fun masterPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterPassword = mapped
    }

    /**
     * @param value ID of the KMS key used to encrypt the cluster admin credentials secret.
     */
    @JvmName("bxinmnjjrqlqfkpn")
    public suspend fun masterPasswordSecretKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterPasswordSecretKmsKeyId = mapped
    }

    /**
     * @param value Username for the master DB user.
     */
    @JvmName("bgpyssaviwwsssrv")
    public suspend fun masterUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterUsername = mapped
    }

    /**
     * @param value Specifies if the Redshift cluster is multi-AZ.
     */
    @JvmName("yvowbwlukqyeplhb")
    public suspend fun multiAz(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiAz = mapped
    }

    /**
     * @param value The node type to be provisioned for the cluster.
     */
    @JvmName("koglxysjjtgdywqm")
    public suspend fun nodeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeType = mapped
    }

    /**
     * @param value The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
     */
    @JvmName("cuhogdgdwwgfaxwt")
    public suspend fun numberOfNodes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfNodes = mapped
    }

    /**
     * @param value The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
     */
    @JvmName("tfarkqaabntjswjk")
    public suspend fun ownerAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerAccount = mapped
    }

    /**
     * @param value The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
     * The cluster is accessible only via the JDBC and ODBC connection strings.
     * Part of the connection string requires the port on which the cluster will listen for incoming connections.
     * Default port is `5439`.
     */
    @JvmName("ogpfshaoldilryxo")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The weekly time range (in UTC) during which automated cluster maintenance can occur.
     * Format: ddd:hh24:mi-ddd:hh24:mi
     */
    @JvmName("dcdtwodlspqjhhox")
    public suspend fun preferredMaintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredMaintenanceWindow = mapped
    }

    /**
     * @param value If true, the cluster can be accessed from a public network. Default is `true`.
     */
    @JvmName("ltlvhwrxqccnlimx")
    public suspend fun publiclyAccessible(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publiclyAccessible = mapped
    }

    /**
     * @param value Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
     */
    @JvmName("gubpaqvxlvkhvdlj")
    public suspend fun skipFinalSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipFinalSnapshot = mapped
    }

    /**
     * @param value The ARN of the snapshot from which to create the new cluster. Conflicts with `snapshot_identifier`.
     */
    @JvmName("uvtluisgaauufyei")
    public suspend fun snapshotArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotArn = mapped
    }

    /**
     * @param value The name of the cluster the source snapshot was created from.
     */
    @JvmName("tgpdmhrvatusdhpg")
    public suspend fun snapshotClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotClusterIdentifier = mapped
    }

    /**
     * @param value Configuration of automatic copy of snapshots from one region to another. Documented below.
     */
    @Deprecated(
        message = """
  Use the aws.redshift.SnapshotCopy resource instead. This argument will be removed in a future
      major version.
  """,
    )
    @JvmName("ebojwdojddtrbxap")
    public suspend fun snapshotCopy(`value`: ClusterSnapshotCopyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotCopy = mapped
    }

    /**
     * @param argument Configuration of automatic copy of snapshots from one region to another. Documented below.
     */
    @Deprecated(
        message = """
  Use the aws.redshift.SnapshotCopy resource instead. This argument will be removed in a future
      major version.
  """,
    )
    @JvmName("nianwlwpgsdghohl")
    public suspend fun snapshotCopy(argument: suspend ClusterSnapshotCopyArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterSnapshotCopyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snapshotCopy = mapped
    }

    /**
     * @param value The name of the snapshot from which to create the new cluster.  Conflicts with `snapshot_arn`.
     */
    @JvmName("anfqymqyiqdktgfi")
    public suspend fun snapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotIdentifier = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lspxslewcvntbsfx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dsejvqbqarwddwlm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     */
    @JvmName("nxyfbkpjbloyowqu")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     */
    @JvmName("qcqrnmnyofuwtwvu")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        allowVersionUpgrade = allowVersionUpgrade,
        applyImmediately = applyImmediately,
        aquaConfigurationStatus = aquaConfigurationStatus,
        automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod,
        availabilityZone = availabilityZone,
        availabilityZoneRelocationEnabled = availabilityZoneRelocationEnabled,
        clusterIdentifier = clusterIdentifier,
        clusterParameterGroupName = clusterParameterGroupName,
        clusterPublicKey = clusterPublicKey,
        clusterRevisionNumber = clusterRevisionNumber,
        clusterSubnetGroupName = clusterSubnetGroupName,
        clusterType = clusterType,
        clusterVersion = clusterVersion,
        databaseName = databaseName,
        defaultIamRoleArn = defaultIamRoleArn,
        elasticIp = elasticIp,
        encrypted = encrypted,
        endpoint = endpoint,
        enhancedVpcRouting = enhancedVpcRouting,
        finalSnapshotIdentifier = finalSnapshotIdentifier,
        iamRoles = iamRoles,
        kmsKeyId = kmsKeyId,
        logging = logging,
        maintenanceTrackName = maintenanceTrackName,
        manageMasterPassword = manageMasterPassword,
        manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod,
        masterPassword = masterPassword,
        masterPasswordSecretKmsKeyId = masterPasswordSecretKmsKeyId,
        masterUsername = masterUsername,
        multiAz = multiAz,
        nodeType = nodeType,
        numberOfNodes = numberOfNodes,
        ownerAccount = ownerAccount,
        port = port,
        preferredMaintenanceWindow = preferredMaintenanceWindow,
        publiclyAccessible = publiclyAccessible,
        skipFinalSnapshot = skipFinalSnapshot,
        snapshotArn = snapshotArn,
        snapshotClusterIdentifier = snapshotClusterIdentifier,
        snapshotCopy = snapshotCopy,
        snapshotIdentifier = snapshotIdentifier,
        tags = tags,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
    )
}
