@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ClusterIamRoles].
 */
@PulumiTagMarker
public class ClusterIamRolesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterIamRolesArgs = ClusterIamRolesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterIamRolesArgsBuilder.() -> Unit) {
        val builder = ClusterIamRolesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterIamRoles {
        val builtJavaResource = com.pulumi.aws.redshift.ClusterIamRoles(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterIamRoles(builtJavaResource)
    }
}

/**
 * Provides a Redshift Cluster IAM Roles resource.
 * > **NOTE:** A Redshift cluster's default IAM role can be managed both by this resource's `default_iam_role_arn` argument and the `aws.redshift.Cluster` resource's `default_iam_role_arn` argument. Do not configure different values for both arguments. Doing so will cause a conflict of default IAM roles.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.ClusterIamRoles("example", {
 *     clusterIdentifier: exampleAwsRedshiftCluster.clusterIdentifier,
 *     iamRoleArns: [exampleAwsIamRole&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.ClusterIamRoles("example",
 *     cluster_identifier=example_aws_redshift_cluster["clusterIdentifier"],
 *     iam_role_arns=[example_aws_iam_role["arn"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.ClusterIamRoles("example", new()
 *     {
 *         ClusterIdentifier = exampleAwsRedshiftCluster.ClusterIdentifier,
 *         IamRoleArns = new[]
 *         {
 *             exampleAwsIamRole.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewClusterIamRoles(ctx, "example", &redshift.ClusterIamRolesArgs{
 * 			ClusterIdentifier: pulumi.Any(exampleAwsRedshiftCluster.ClusterIdentifier),
 * 			IamRoleArns: pulumi.StringArray{
 * 				exampleAwsIamRole.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.ClusterIamRoles;
 * import com.pulumi.aws.redshift.ClusterIamRolesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterIamRoles("example", ClusterIamRolesArgs.builder()
 *             .clusterIdentifier(exampleAwsRedshiftCluster.clusterIdentifier())
 *             .iamRoleArns(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:ClusterIamRoles
 *     properties:
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.clusterIdentifier}
 *       iamRoleArns:
 *         - ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Cluster IAM Roless using the `cluster_identifier`. For example:
 * ```sh
 * $ pulumi import aws:redshift/clusterIamRoles:ClusterIamRoles examplegroup1 example
 * ```
 */
public class ClusterIamRoles internal constructor(
    override val javaResource: com.pulumi.aws.redshift.ClusterIamRoles,
) : KotlinCustomResource(javaResource, ClusterIamRolesMapper) {
    /**
     * The name of the Redshift Cluster IAM Roles.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
     */
    public val defaultIamRoleArn: Output<String>
        get() = javaResource.defaultIamRoleArn().applyValue({ args0 -> args0 })

    /**
     * A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     */
    public val iamRoleArns: Output<List<String>>
        get() = javaResource.iamRoleArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ClusterIamRolesMapper : ResourceMapper<ClusterIamRoles> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.ClusterIamRoles::class == javaResource::class

    override fun map(javaResource: Resource): ClusterIamRoles = ClusterIamRoles(
        javaResource as
            com.pulumi.aws.redshift.ClusterIamRoles,
    )
}

/**
 * @see [ClusterIamRoles].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterIamRoles].
 */
public suspend fun clusterIamRoles(
    name: String,
    block: suspend ClusterIamRolesResourceBuilder.() -> Unit,
): ClusterIamRoles {
    val builder = ClusterIamRolesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterIamRoles].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterIamRoles(name: String): ClusterIamRoles {
    val builder = ClusterIamRolesResourceBuilder()
    builder.name(name)
    return builder.build()
}
