@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ClusterSnapshot].
 */
@PulumiTagMarker
public class ClusterSnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterSnapshotArgs = ClusterSnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterSnapshotArgsBuilder.() -> Unit) {
        val builder = ClusterSnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterSnapshot {
        val builtJavaResource = com.pulumi.aws.redshift.ClusterSnapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterSnapshot(builtJavaResource)
    }
}

/**
 * Creates a Redshift cluster snapshot
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:ClusterSnapshot
 *     properties:
 *       clusterSnapshotName: example
 *       clusterSnapshotContent:
 *         fn::toJSON:
 *           AllowDBUserOverride: '1'
 *           Client_ID: ExampleClientID
 *           App_ID: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Cluster Snapshots using `snapshot_identifier`. For example:
 * ```sh
 * $ pulumi import aws:redshift/clusterSnapshot:ClusterSnapshot test example
 * ```
 */
public class ClusterSnapshot internal constructor(
    override val javaResource: com.pulumi.aws.redshift.ClusterSnapshot,
) : KotlinCustomResource(javaResource, ClusterSnapshotMapper) {
    /**
     * Amazon Resource Name (ARN) of the snapshot.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The cluster identifier for which you want a snapshot.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The number of days that a manual snapshot is retained. If the value is `-1`, the manual snapshot is retained indefinitely. Valid values are -1 and between `1` and `3653`.
     */
    public val manualSnapshotRetentionPeriod: Output<Int>?
        get() = javaResource.manualSnapshotRetentionPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.
     */
    public val ownerAccount: Output<String>
        get() = javaResource.ownerAccount().applyValue({ args0 -> args0 })

    /**
     * A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.
     */
    public val snapshotIdentifier: Output<String>
        get() = javaResource.snapshotIdentifier().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ClusterSnapshotMapper : ResourceMapper<ClusterSnapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.ClusterSnapshot::class == javaResource::class

    override fun map(javaResource: Resource): ClusterSnapshot = ClusterSnapshot(
        javaResource as
            com.pulumi.aws.redshift.ClusterSnapshot,
    )
}

/**
 * @see [ClusterSnapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterSnapshot].
 */
public suspend fun clusterSnapshot(
    name: String,
    block: suspend ClusterSnapshotResourceBuilder.() -> Unit,
): ClusterSnapshot {
    val builder = ClusterSnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterSnapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterSnapshot(name: String): ClusterSnapshot {
    val builder = ClusterSnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
