@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.ClusterSnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a Redshift cluster snapshot
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:ClusterSnapshot
 *     properties:
 *       clusterSnapshotName: example
 *       clusterSnapshotContent:
 *         fn::toJSON:
 *           AllowDBUserOverride: '1'
 *           Client_ID: ExampleClientID
 *           App_ID: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Cluster Snapshots using `snapshot_identifier`. For example:
 * ```sh
 * $ pulumi import aws:redshift/clusterSnapshot:ClusterSnapshot test example
 * ```
 * @property clusterIdentifier The cluster identifier for which you want a snapshot.
 * @property manualSnapshotRetentionPeriod The number of days that a manual snapshot is retained. If the value is `-1`, the manual snapshot is retained indefinitely. Valid values are -1 and between `1` and `3653`.
 * @property snapshotIdentifier A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterSnapshotArgs(
    public val clusterIdentifier: Output<String>? = null,
    public val manualSnapshotRetentionPeriod: Output<Int>? = null,
    public val snapshotIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.ClusterSnapshotArgs> {
    override fun toJava(): com.pulumi.aws.redshift.ClusterSnapshotArgs =
        com.pulumi.aws.redshift.ClusterSnapshotArgs.builder()
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod?.applyValue({ args0 -> args0 }))
            .snapshotIdentifier(snapshotIdentifier?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterSnapshotArgs].
 */
@PulumiTagMarker
public class ClusterSnapshotArgsBuilder internal constructor() {
    private var clusterIdentifier: Output<String>? = null

    private var manualSnapshotRetentionPeriod: Output<Int>? = null

    private var snapshotIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The cluster identifier for which you want a snapshot.
     */
    @JvmName("oapxvqemiqmdrihn")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The number of days that a manual snapshot is retained. If the value is `-1`, the manual snapshot is retained indefinitely. Valid values are -1 and between `1` and `3653`.
     */
    @JvmName("usmfnjnokvmsqjyu")
    public suspend fun manualSnapshotRetentionPeriod(`value`: Output<Int>) {
        this.manualSnapshotRetentionPeriod = value
    }

    /**
     * @param value A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.
     */
    @JvmName("whjxsserludlfufg")
    public suspend fun snapshotIdentifier(`value`: Output<String>) {
        this.snapshotIdentifier = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qrcqcihluxkhbble")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The cluster identifier for which you want a snapshot.
     */
    @JvmName("ayjyhovvcoahchgi")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The number of days that a manual snapshot is retained. If the value is `-1`, the manual snapshot is retained indefinitely. Valid values are -1 and between `1` and `3653`.
     */
    @JvmName("aotbubhxifgdhgra")
    public suspend fun manualSnapshotRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manualSnapshotRetentionPeriod = mapped
    }

    /**
     * @param value A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.
     */
    @JvmName("tyyddkqujihypqhh")
    public suspend fun snapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotIdentifier = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lciauyoawbhbuvxo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rdkvpawdbuqbjpjd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterSnapshotArgs = ClusterSnapshotArgs(
        clusterIdentifier = clusterIdentifier,
        manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod,
        snapshotIdentifier = snapshotIdentifier,
        tags = tags,
    )
}
