@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DataShareAuthorization].
 */
@PulumiTagMarker
public class DataShareAuthorizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataShareAuthorizationArgs = DataShareAuthorizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataShareAuthorizationArgsBuilder.() -> Unit) {
        val builder = DataShareAuthorizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataShareAuthorization {
        val builtJavaResource = com.pulumi.aws.redshift.DataShareAuthorization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataShareAuthorization(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Redshift Data Share Authorization.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.DataShareAuthorization("example", {
 *     consumerIdentifier: "012345678901",
 *     dataShareArn: "arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.DataShareAuthorization("example",
 *     consumer_identifier="012345678901",
 *     data_share_arn="arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.DataShareAuthorization("example", new()
 *     {
 *         ConsumerIdentifier = "012345678901",
 *         DataShareArn = "arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewDataShareAuthorization(ctx, "example", &redshift.DataShareAuthorizationArgs{
 * 			ConsumerIdentifier: pulumi.String("012345678901"),
 * 			DataShareArn:       pulumi.String("arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.DataShareAuthorization;
 * import com.pulumi.aws.redshift.DataShareAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataShareAuthorization("example", DataShareAuthorizationArgs.builder()
 *             .consumerIdentifier("012345678901")
 *             .dataShareArn("arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:DataShareAuthorization
 *     properties:
 *       consumerIdentifier: '012345678901'
 *       dataShareArn: arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Data Share Authorization using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshift/dataShareAuthorization:DataShareAuthorization example arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share,012345678901
 * ```
 */
public class DataShareAuthorization internal constructor(
    override val javaResource: com.pulumi.aws.redshift.DataShareAuthorization,
) : KotlinCustomResource(javaResource, DataShareAuthorizationMapper) {
    /**
     * Whether to allow write operations for a datashare.
     */
    public val allowWrites: Output<Boolean>?
        get() = javaResource.allowWrites().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS account ID or a keyword, such as `ADX`.
     */
    public val consumerIdentifier: Output<String>
        get() = javaResource.consumerIdentifier().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.
     * The following arguments are optional:
     */
    public val dataShareArn: Output<String>
        get() = javaResource.dataShareArn().applyValue({ args0 -> args0 })

    /**
     * Identifier of a datashare to show its managing entity.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the producer.
     */
    public val producerArn: Output<String>
        get() = javaResource.producerArn().applyValue({ args0 -> args0 })
}

public object DataShareAuthorizationMapper : ResourceMapper<DataShareAuthorization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.DataShareAuthorization::class == javaResource::class

    override fun map(javaResource: Resource): DataShareAuthorization =
        DataShareAuthorization(javaResource as com.pulumi.aws.redshift.DataShareAuthorization)
}

/**
 * @see [DataShareAuthorization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataShareAuthorization].
 */
public suspend fun dataShareAuthorization(
    name: String,
    block: suspend DataShareAuthorizationResourceBuilder.() -> Unit,
): DataShareAuthorization {
    val builder = DataShareAuthorizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataShareAuthorization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataShareAuthorization(name: String): DataShareAuthorization {
    val builder = DataShareAuthorizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
