@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.DataShareAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Redshift Data Share Authorization.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.DataShareAuthorization("example", {
 *     consumerIdentifier: "012345678901",
 *     dataShareArn: "arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.DataShareAuthorization("example",
 *     consumer_identifier="012345678901",
 *     data_share_arn="arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.DataShareAuthorization("example", new()
 *     {
 *         ConsumerIdentifier = "012345678901",
 *         DataShareArn = "arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewDataShareAuthorization(ctx, "example", &redshift.DataShareAuthorizationArgs{
 * 			ConsumerIdentifier: pulumi.String("012345678901"),
 * 			DataShareArn:       pulumi.String("arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.DataShareAuthorization;
 * import com.pulumi.aws.redshift.DataShareAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataShareAuthorization("example", DataShareAuthorizationArgs.builder()
 *             .consumerIdentifier("012345678901")
 *             .dataShareArn("arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:DataShareAuthorization
 *     properties:
 *       consumerIdentifier: '012345678901'
 *       dataShareArn: arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Data Share Authorization using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshift/dataShareAuthorization:DataShareAuthorization example arn:aws:redshift:us-west-2:012345678901:datashare:3072dae5-022b-4d45-9cd3-01f010aae4b2/example_share,012345678901
 * ```
 * @property allowWrites Whether to allow write operations for a datashare.
 * @property consumerIdentifier Identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS account ID or a keyword, such as `ADX`.
 * @property dataShareArn Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.
 * The following arguments are optional:
 */
public data class DataShareAuthorizationArgs(
    public val allowWrites: Output<Boolean>? = null,
    public val consumerIdentifier: Output<String>? = null,
    public val dataShareArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.DataShareAuthorizationArgs> {
    override fun toJava(): com.pulumi.aws.redshift.DataShareAuthorizationArgs =
        com.pulumi.aws.redshift.DataShareAuthorizationArgs.builder()
            .allowWrites(allowWrites?.applyValue({ args0 -> args0 }))
            .consumerIdentifier(consumerIdentifier?.applyValue({ args0 -> args0 }))
            .dataShareArn(dataShareArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataShareAuthorizationArgs].
 */
@PulumiTagMarker
public class DataShareAuthorizationArgsBuilder internal constructor() {
    private var allowWrites: Output<Boolean>? = null

    private var consumerIdentifier: Output<String>? = null

    private var dataShareArn: Output<String>? = null

    /**
     * @param value Whether to allow write operations for a datashare.
     */
    @JvmName("aqolinaprwaoxawo")
    public suspend fun allowWrites(`value`: Output<Boolean>) {
        this.allowWrites = value
    }

    /**
     * @param value Identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS account ID or a keyword, such as `ADX`.
     */
    @JvmName("cvadcnkitypffeuk")
    public suspend fun consumerIdentifier(`value`: Output<String>) {
        this.consumerIdentifier = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.
     * The following arguments are optional:
     */
    @JvmName("pgsdsslvgsytrmxk")
    public suspend fun dataShareArn(`value`: Output<String>) {
        this.dataShareArn = value
    }

    /**
     * @param value Whether to allow write operations for a datashare.
     */
    @JvmName("lsrxmkfftqyyhccq")
    public suspend fun allowWrites(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowWrites = mapped
    }

    /**
     * @param value Identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS account ID or a keyword, such as `ADX`.
     */
    @JvmName("lqxmlfynlxpegktr")
    public suspend fun consumerIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerIdentifier = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.
     * The following arguments are optional:
     */
    @JvmName("ojqtblrhicewstqr")
    public suspend fun dataShareArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataShareArn = mapped
    }

    internal fun build(): DataShareAuthorizationArgs = DataShareAuthorizationArgs(
        allowWrites = allowWrites,
        consumerIdentifier = consumerIdentifier,
        dataShareArn = dataShareArn,
    )
}
