@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DataShareConsumerAssociation].
 */
@PulumiTagMarker
public class DataShareConsumerAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataShareConsumerAssociationArgs = DataShareConsumerAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataShareConsumerAssociationArgsBuilder.() -> Unit) {
        val builder = DataShareConsumerAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataShareConsumerAssociation {
        val builtJavaResource =
            com.pulumi.aws.redshift.DataShareConsumerAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataShareConsumerAssociation(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Redshift Data Share Consumer Association.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.DataShareConsumerAssociation("example", {
 *     dataShareArn: "arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example",
 *     associateEntireAccount: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.DataShareConsumerAssociation("example",
 *     data_share_arn="arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example",
 *     associate_entire_account=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.DataShareConsumerAssociation("example", new()
 *     {
 *         DataShareArn = "arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example",
 *         AssociateEntireAccount = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewDataShareConsumerAssociation(ctx, "example", &redshift.DataShareConsumerAssociationArgs{
 * 			DataShareArn:           pulumi.String("arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example"),
 * 			AssociateEntireAccount: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.DataShareConsumerAssociation;
 * import com.pulumi.aws.redshift.DataShareConsumerAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataShareConsumerAssociation("example", DataShareConsumerAssociationArgs.builder()
 *             .dataShareArn("arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example")
 *             .associateEntireAccount(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:DataShareConsumerAssociation
 *     properties:
 *       dataShareArn: arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example
 *       associateEntireAccount: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Consumer Region
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.DataShareConsumerAssociation("example", {
 *     dataShareArn: "arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example",
 *     consumerRegion: "us-west-2",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.DataShareConsumerAssociation("example",
 *     data_share_arn="arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example",
 *     consumer_region="us-west-2")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.DataShareConsumerAssociation("example", new()
 *     {
 *         DataShareArn = "arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example",
 *         ConsumerRegion = "us-west-2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewDataShareConsumerAssociation(ctx, "example", &redshift.DataShareConsumerAssociationArgs{
 * 			DataShareArn:   pulumi.String("arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example"),
 * 			ConsumerRegion: pulumi.String("us-west-2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.DataShareConsumerAssociation;
 * import com.pulumi.aws.redshift.DataShareConsumerAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataShareConsumerAssociation("example", DataShareConsumerAssociationArgs.builder()
 *             .dataShareArn("arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example")
 *             .consumerRegion("us-west-2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:DataShareConsumerAssociation
 *     properties:
 *       dataShareArn: arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example
 *       consumerRegion: us-west-2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Data Share Consumer Association using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshift/dataShareConsumerAssociation:DataShareConsumerAssociation example arn:aws:redshift:us-west-2:012345678901:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example,,,us-west-2
 * ```
 */
public class DataShareConsumerAssociation internal constructor(
    override val javaResource: com.pulumi.aws.redshift.DataShareConsumerAssociation,
) : KotlinCustomResource(javaResource, DataShareConsumerAssociationMapper) {
    /**
     * Whether to allow write operations for a datashare.
     */
    public val allowWrites: Output<Boolean>?
        get() = javaResource.allowWrites().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the datashare is associated with the entire account. Conflicts with `consumer_arn` and `consumer_region`.
     */
    public val associateEntireAccount: Output<Boolean>?
        get() = javaResource.associateEntireAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the consumer that is associated with the datashare. Conflicts with `associate_entire_account` and `consumer_region`.
     */
    public val consumerArn: Output<String>?
        get() = javaResource.consumerArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified AWS Region. Conflicts with `associate_entire_account` and `consumer_arn`.
     */
    public val consumerRegion: Output<String>?
        get() = javaResource.consumerRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.
     * The following arguments are optional:
     */
    public val dataShareArn: Output<String>
        get() = javaResource.dataShareArn().applyValue({ args0 -> args0 })

    /**
     * Identifier of a datashare to show its managing entity.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the producer.
     */
    public val producerArn: Output<String>
        get() = javaResource.producerArn().applyValue({ args0 -> args0 })
}

public object DataShareConsumerAssociationMapper : ResourceMapper<DataShareConsumerAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.DataShareConsumerAssociation::class == javaResource::class

    override fun map(javaResource: Resource): DataShareConsumerAssociation =
        DataShareConsumerAssociation(
            javaResource as
                com.pulumi.aws.redshift.DataShareConsumerAssociation,
        )
}

/**
 * @see [DataShareConsumerAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataShareConsumerAssociation].
 */
public suspend fun dataShareConsumerAssociation(
    name: String,
    block: suspend DataShareConsumerAssociationResourceBuilder.() -> Unit,
): DataShareConsumerAssociation {
    val builder = DataShareConsumerAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataShareConsumerAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataShareConsumerAssociation(name: String): DataShareConsumerAssociation {
    val builder = DataShareConsumerAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
