@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.EndpointAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift endpoint access.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.EndpointAccess("example", {
 *     endpointName: "example",
 *     subnetGroupName: exampleAwsRedshiftSubnetGroup.id,
 *     clusterIdentifier: exampleAwsRedshiftCluster.clusterIdentifier,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.EndpointAccess("example",
 *     endpoint_name="example",
 *     subnet_group_name=example_aws_redshift_subnet_group["id"],
 *     cluster_identifier=example_aws_redshift_cluster["clusterIdentifier"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.EndpointAccess("example", new()
 *     {
 *         EndpointName = "example",
 *         SubnetGroupName = exampleAwsRedshiftSubnetGroup.Id,
 *         ClusterIdentifier = exampleAwsRedshiftCluster.ClusterIdentifier,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewEndpointAccess(ctx, "example", &redshift.EndpointAccessArgs{
 * 			EndpointName:      pulumi.String("example"),
 * 			SubnetGroupName:   pulumi.Any(exampleAwsRedshiftSubnetGroup.Id),
 * 			ClusterIdentifier: pulumi.Any(exampleAwsRedshiftCluster.ClusterIdentifier),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.EndpointAccess;
 * import com.pulumi.aws.redshift.EndpointAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EndpointAccess("example", EndpointAccessArgs.builder()
 *             .endpointName("example")
 *             .subnetGroupName(exampleAwsRedshiftSubnetGroup.id())
 *             .clusterIdentifier(exampleAwsRedshiftCluster.clusterIdentifier())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:EndpointAccess
 *     properties:
 *       endpointName: example
 *       subnetGroupName: ${exampleAwsRedshiftSubnetGroup.id}
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.clusterIdentifier}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift endpoint access using the `name`. For example:
 * ```sh
 * $ pulumi import aws:redshift/endpointAccess:EndpointAccess example example
 * ```
 * @property clusterIdentifier The cluster identifier of the cluster to access.
 * @property endpointName The Redshift-managed VPC endpoint name.
 * @property resourceOwner The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
 * @property subnetGroupName The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
 * @property vpcSecurityGroupIds The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
 */
public data class EndpointAccessArgs(
    public val clusterIdentifier: Output<String>? = null,
    public val endpointName: Output<String>? = null,
    public val resourceOwner: Output<String>? = null,
    public val subnetGroupName: Output<String>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.EndpointAccessArgs> {
    override fun toJava(): com.pulumi.aws.redshift.EndpointAccessArgs =
        com.pulumi.aws.redshift.EndpointAccessArgs.builder()
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .resourceOwner(resourceOwner?.applyValue({ args0 -> args0 }))
            .subnetGroupName(subnetGroupName?.applyValue({ args0 -> args0 }))
            .vpcSecurityGroupIds(
                vpcSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [EndpointAccessArgs].
 */
@PulumiTagMarker
public class EndpointAccessArgsBuilder internal constructor() {
    private var clusterIdentifier: Output<String>? = null

    private var endpointName: Output<String>? = null

    private var resourceOwner: Output<String>? = null

    private var subnetGroupName: Output<String>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    /**
     * @param value The cluster identifier of the cluster to access.
     */
    @JvmName("thgwallmevogkabd")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The Redshift-managed VPC endpoint name.
     */
    @JvmName("ajbcitcxbdsghbew")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
     */
    @JvmName("bpmskgoyjjukarei")
    public suspend fun resourceOwner(`value`: Output<String>) {
        this.resourceOwner = value
    }

    /**
     * @param value The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
     */
    @JvmName("hcharpbxaqmfvlpt")
    public suspend fun subnetGroupName(`value`: Output<String>) {
        this.subnetGroupName = value
    }

    /**
     * @param value The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     */
    @JvmName("xvxlncgomexometn")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("xwsrvdtlovphekrj")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     */
    @JvmName("qksuaccxfsecnfpm")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value The cluster identifier of the cluster to access.
     */
    @JvmName("ptgljuskeqftghyx")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The Redshift-managed VPC endpoint name.
     */
    @JvmName("bgcaxvdwskwdvypc")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
     */
    @JvmName("eflpawssldolbetn")
    public suspend fun resourceOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceOwner = mapped
    }

    /**
     * @param value The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
     */
    @JvmName("tqwerrgkygjoiysj")
    public suspend fun subnetGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetGroupName = mapped
    }

    /**
     * @param value The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     */
    @JvmName("hvdvwkwebvslrbir")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     */
    @JvmName("iqmldecsbmgxniat")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    internal fun build(): EndpointAccessArgs = EndpointAccessArgs(
        clusterIdentifier = clusterIdentifier,
        endpointName = endpointName,
        resourceOwner = resourceOwner,
        subnetGroupName = subnetGroupName,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
    )
}
