@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [EndpointAuthorization].
 */
@PulumiTagMarker
public class EndpointAuthorizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointAuthorizationArgs = EndpointAuthorizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointAuthorizationArgsBuilder.() -> Unit) {
        val builder = EndpointAuthorizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EndpointAuthorization {
        val builtJavaResource = com.pulumi.aws.redshift.EndpointAuthorization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EndpointAuthorization(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift endpoint authorization.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.EndpointAuthorization("example", {
 *     account: "01234567910",
 *     clusterIdentifier: exampleAwsRedshiftCluster.clusterIdentifier,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.EndpointAuthorization("example",
 *     account="01234567910",
 *     cluster_identifier=example_aws_redshift_cluster["clusterIdentifier"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.EndpointAuthorization("example", new()
 *     {
 *         Account = "01234567910",
 *         ClusterIdentifier = exampleAwsRedshiftCluster.ClusterIdentifier,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewEndpointAuthorization(ctx, "example", &redshift.EndpointAuthorizationArgs{
 * 			Account:           pulumi.String("01234567910"),
 * 			ClusterIdentifier: pulumi.Any(exampleAwsRedshiftCluster.ClusterIdentifier),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.EndpointAuthorization;
 * import com.pulumi.aws.redshift.EndpointAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EndpointAuthorization("example", EndpointAuthorizationArgs.builder()
 *             .account("01234567910")
 *             .clusterIdentifier(exampleAwsRedshiftCluster.clusterIdentifier())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:EndpointAuthorization
 *     properties:
 *       account: '01234567910'
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.clusterIdentifier}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift endpoint authorization using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshift/endpointAuthorization:EndpointAuthorization example 01234567910:cluster-example-id
 * ```
 */
public class EndpointAuthorization internal constructor(
    override val javaResource: com.pulumi.aws.redshift.EndpointAuthorization,
) : KotlinCustomResource(javaResource, EndpointAuthorizationMapper) {
    /**
     * The Amazon Web Services account ID to grant access to.
     */
    public val account: Output<String>
        get() = javaResource.account().applyValue({ args0 -> args0 })

    /**
     * Indicates whether all VPCs in the grantee account are allowed access to the cluster.
     */
    public val allowedAllVpcs: Output<Boolean>
        get() = javaResource.allowedAllVpcs().applyValue({ args0 -> args0 })

    /**
     * The cluster identifier of the cluster to grant access to.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The number of Redshift-managed VPC endpoints created for the authorization.
     */
    public val endpointCount: Output<Int>
        get() = javaResource.endpointCount().applyValue({ args0 -> args0 })

    /**
     * Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
     */
    public val forceDelete: Output<Boolean>?
        get() = javaResource.forceDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Web Services account ID of the grantee of the cluster.
     */
    public val grantee: Output<String>
        get() = javaResource.grantee().applyValue({ args0 -> args0 })

    /**
     * The Amazon Web Services account ID of the cluster owner.
     */
    public val grantor: Output<String>
        get() = javaResource.grantor().applyValue({ args0 -> args0 })

    /**
     * The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
     */
    public val vpcIds: Output<List<String>>?
        get() = javaResource.vpcIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object EndpointAuthorizationMapper : ResourceMapper<EndpointAuthorization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.EndpointAuthorization::class == javaResource::class

    override fun map(javaResource: Resource): EndpointAuthorization =
        EndpointAuthorization(javaResource as com.pulumi.aws.redshift.EndpointAuthorization)
}

/**
 * @see [EndpointAuthorization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EndpointAuthorization].
 */
public suspend fun endpointAuthorization(
    name: String,
    block: suspend EndpointAuthorizationResourceBuilder.() -> Unit,
): EndpointAuthorization {
    val builder = EndpointAuthorizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EndpointAuthorization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpointAuthorization(name: String): EndpointAuthorization {
    val builder = EndpointAuthorizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
