@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.EndpointAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift endpoint authorization.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.EndpointAuthorization("example", {
 *     account: "01234567910",
 *     clusterIdentifier: exampleAwsRedshiftCluster.clusterIdentifier,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.EndpointAuthorization("example",
 *     account="01234567910",
 *     cluster_identifier=example_aws_redshift_cluster["clusterIdentifier"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.EndpointAuthorization("example", new()
 *     {
 *         Account = "01234567910",
 *         ClusterIdentifier = exampleAwsRedshiftCluster.ClusterIdentifier,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewEndpointAuthorization(ctx, "example", &redshift.EndpointAuthorizationArgs{
 * 			Account:           pulumi.String("01234567910"),
 * 			ClusterIdentifier: pulumi.Any(exampleAwsRedshiftCluster.ClusterIdentifier),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.EndpointAuthorization;
 * import com.pulumi.aws.redshift.EndpointAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EndpointAuthorization("example", EndpointAuthorizationArgs.builder()
 *             .account("01234567910")
 *             .clusterIdentifier(exampleAwsRedshiftCluster.clusterIdentifier())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:EndpointAuthorization
 *     properties:
 *       account: '01234567910'
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.clusterIdentifier}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift endpoint authorization using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshift/endpointAuthorization:EndpointAuthorization example 01234567910:cluster-example-id
 * ```
 * @property account The Amazon Web Services account ID to grant access to.
 * @property clusterIdentifier The cluster identifier of the cluster to grant access to.
 * @property forceDelete Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
 * @property vpcIds The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
 */
public data class EndpointAuthorizationArgs(
    public val account: Output<String>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val forceDelete: Output<Boolean>? = null,
    public val vpcIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.EndpointAuthorizationArgs> {
    override fun toJava(): com.pulumi.aws.redshift.EndpointAuthorizationArgs =
        com.pulumi.aws.redshift.EndpointAuthorizationArgs.builder()
            .account(account?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .forceDelete(forceDelete?.applyValue({ args0 -> args0 }))
            .vpcIds(vpcIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EndpointAuthorizationArgs].
 */
@PulumiTagMarker
public class EndpointAuthorizationArgsBuilder internal constructor() {
    private var account: Output<String>? = null

    private var clusterIdentifier: Output<String>? = null

    private var forceDelete: Output<Boolean>? = null

    private var vpcIds: Output<List<String>>? = null

    /**
     * @param value The Amazon Web Services account ID to grant access to.
     */
    @JvmName("vqnjwrlndwvkfyki")
    public suspend fun account(`value`: Output<String>) {
        this.account = value
    }

    /**
     * @param value The cluster identifier of the cluster to grant access to.
     */
    @JvmName("dpntrtekikvwveni")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
     */
    @JvmName("dyqbuwkwstvysldu")
    public suspend fun forceDelete(`value`: Output<Boolean>) {
        this.forceDelete = value
    }

    /**
     * @param value The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
     */
    @JvmName("ulqsqecxbkbnhtbn")
    public suspend fun vpcIds(`value`: Output<List<String>>) {
        this.vpcIds = value
    }

    @JvmName("fehdowxwmwqrvxwl")
    public suspend fun vpcIds(vararg values: Output<String>) {
        this.vpcIds = Output.all(values.asList())
    }

    /**
     * @param values The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
     */
    @JvmName("rxaqjdhgtbxynpyp")
    public suspend fun vpcIds(values: List<Output<String>>) {
        this.vpcIds = Output.all(values)
    }

    /**
     * @param value The Amazon Web Services account ID to grant access to.
     */
    @JvmName("oaxrkrsxgqswndaq")
    public suspend fun account(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.account = mapped
    }

    /**
     * @param value The cluster identifier of the cluster to grant access to.
     */
    @JvmName("nkwxtxkbkaekpncr")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
     */
    @JvmName("mcfmnvwxhwiskwib")
    public suspend fun forceDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDelete = mapped
    }

    /**
     * @param value The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
     */
    @JvmName("obrhedhgmsaagcem")
    public suspend fun vpcIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcIds = mapped
    }

    /**
     * @param values The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
     */
    @JvmName("nceluxmjjfrabyyc")
    public suspend fun vpcIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcIds = mapped
    }

    internal fun build(): EndpointAuthorizationArgs = EndpointAuthorizationArgs(
        account = account,
        clusterIdentifier = clusterIdentifier,
        forceDelete = forceDelete,
        vpcIds = vpcIds,
    )
}
