@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [EventSubscription].
 */
@PulumiTagMarker
public class EventSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventSubscriptionArgs = EventSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventSubscriptionArgsBuilder.() -> Unit) {
        val builder = EventSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventSubscription {
        val builtJavaResource = com.pulumi.aws.redshift.EventSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventSubscription(builtJavaResource)
    }
}

/**
 * Provides a Redshift event subscription resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.redshift.Cluster("default", {
 *     clusterIdentifier: "default",
 *     databaseName: "default",
 * });
 * const defaultTopic = new aws.sns.Topic("default", {name: "redshift-events"});
 * const defaultEventSubscription = new aws.redshift.EventSubscription("default", {
 *     name: "redshift-event-sub",
 *     snsTopicArn: defaultTopic.arn,
 *     sourceType: "cluster",
 *     sourceIds: [_default&#46;id],
 *     severity: "INFO",
 *     eventCategories: [
 *         "configuration",
 *         "management",
 *         "monitoring",
 *         "security",
 *     ],
 *     tags: {
 *         Name: "default",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.redshift.Cluster("default",
 *     cluster_identifier="default",
 *     database_name="default")
 * default_topic = aws.sns.Topic("default", name="redshift-events")
 * default_event_subscription = aws.redshift.EventSubscription("default",
 *     name="redshift-event-sub",
 *     sns_topic_arn=default_topic.arn,
 *     source_type="cluster",
 *     source_ids=[default&#46;id],
 *     severity="INFO",
 *     event_categories=[
 *         "configuration",
 *         "management",
 *         "monitoring",
 *         "security",
 *     ],
 *     tags={
 *         "Name": "default",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.RedShift.Cluster("default", new()
 *     {
 *         ClusterIdentifier = "default",
 *         DatabaseName = "default",
 *     });
 *     var defaultTopic = new Aws.Sns.Topic("default", new()
 *     {
 *         Name = "redshift-events",
 *     });
 *     var defaultEventSubscription = new Aws.RedShift.EventSubscription("default", new()
 *     {
 *         Name = "redshift-event-sub",
 *         SnsTopicArn = defaultTopic.Arn,
 *         SourceType = "cluster",
 *         SourceIds = new[]
 *         {
 *             @default.Id,
 *         },
 *         Severity = "INFO",
 *         EventCategories = new[]
 *         {
 *             "configuration",
 *             "management",
 *             "monitoring",
 *             "security",
 *         },
 *         Tags =
 *         {
 *             { "Name", "default" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewCluster(ctx, "default", &redshift.ClusterArgs{
 * 			ClusterIdentifier: pulumi.String("default"),
 * 			DatabaseName:      pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTopic, err := sns.NewTopic(ctx, "default", &sns.TopicArgs{
 * 			Name: pulumi.String("redshift-events"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = redshift.NewEventSubscription(ctx, "default", &redshift.EventSubscriptionArgs{
 * 			Name:        pulumi.String("redshift-event-sub"),
 * 			SnsTopicArn: defaultTopic.Arn,
 * 			SourceType:  pulumi.String("cluster"),
 * 			SourceIds: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 			Severity: pulumi.String("INFO"),
 * 			EventCategories: pulumi.StringArray{
 * 				pulumi.String("configuration"),
 * 				pulumi.String("management"),
 * 				pulumi.String("monitoring"),
 * 				pulumi.String("security"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("default"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.redshift.EventSubscription;
 * import com.pulumi.aws.redshift.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("default")
 *             .databaseName("default")
 *             .build());
 *         var defaultTopic = new Topic("defaultTopic", TopicArgs.builder()
 *             .name("redshift-events")
 *             .build());
 *         var defaultEventSubscription = new EventSubscription("defaultEventSubscription", EventSubscriptionArgs.builder()
 *             .name("redshift-event-sub")
 *             .snsTopicArn(defaultTopic.arn())
 *             .sourceType("cluster")
 *             .sourceIds(default_.id())
 *             .severity("INFO")
 *             .eventCategories(
 *                 "configuration",
 *                 "management",
 *                 "monitoring",
 *                 "security")
 *             .tags(Map.of("Name", "default"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:redshift:Cluster
 *     properties:
 *       clusterIdentifier: default
 *       databaseName: default
 *   defaultTopic:
 *     type: aws:sns:Topic
 *     name: default
 *     properties:
 *       name: redshift-events
 *   defaultEventSubscription:
 *     type: aws:redshift:EventSubscription
 *     name: default
 *     properties:
 *       name: redshift-event-sub
 *       snsTopicArn: ${defaultTopic.arn}
 *       sourceType: cluster
 *       sourceIds:
 *         - ${default.id}
 *       severity: INFO
 *       eventCategories:
 *         - configuration
 *         - management
 *         - monitoring
 *         - security
 *       tags:
 *         Name: default
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Event Subscriptions using the `name`. For example:
 * ```sh
 * $ pulumi import aws:redshift/eventSubscription:EventSubscription default redshift-event-sub
 * ```
 */
public class EventSubscription internal constructor(
    override val javaResource: com.pulumi.aws.redshift.EventSubscription,
) : KotlinCustomResource(javaResource, EventSubscriptionMapper) {
    /**
     * Amazon Resource Name (ARN) of the Redshift event notification subscription
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AWS customer account associated with the Redshift event notification subscription
     */
    public val customerAwsId: Output<String>
        get() = javaResource.customerAwsId().applyValue({ args0 -> args0 })

    /**
     * A boolean flag to enable/disable the subscription. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html or run `aws redshift describe-event-categories`.
     */
    public val eventCategories: Output<List<String>>?
        get() = javaResource.eventCategories().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name of the Redshift event subscription.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The event severity to be published by the notification subscription. Valid options are `INFO` or `ERROR`. Default value of `INFO`.
     */
    public val severity: Output<String>?
        get() = javaResource.severity().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ARN of the SNS topic to send events to.
     */
    public val snsTopicArn: Output<String>
        get() = javaResource.snsTopicArn().applyValue({ args0 -> args0 })

    /**
     * A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a `source_type` must also be specified.
     */
    public val sourceIds: Output<List<String>>?
        get() = javaResource.sourceIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The type of source that will be generating the events. Valid options are `cluster`, `cluster-parameter-group`, `cluster-security-group`, `cluster-snapshot`, or `scheduled-action`. If not set, all sources will be subscribed to.
     */
    public val sourceType: Output<String>?
        get() = javaResource.sourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object EventSubscriptionMapper : ResourceMapper<EventSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.EventSubscription::class == javaResource::class

    override fun map(javaResource: Resource): EventSubscription = EventSubscription(
        javaResource as
            com.pulumi.aws.redshift.EventSubscription,
    )
}

/**
 * @see [EventSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventSubscription].
 */
public suspend fun eventSubscription(
    name: String,
    block: suspend EventSubscriptionResourceBuilder.() -> Unit,
): EventSubscription {
    val builder = EventSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventSubscription(name: String): EventSubscription {
    val builder = EventSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
