@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.EventSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Redshift event subscription resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.redshift.Cluster("default", {
 *     clusterIdentifier: "default",
 *     databaseName: "default",
 * });
 * const defaultTopic = new aws.sns.Topic("default", {name: "redshift-events"});
 * const defaultEventSubscription = new aws.redshift.EventSubscription("default", {
 *     name: "redshift-event-sub",
 *     snsTopicArn: defaultTopic.arn,
 *     sourceType: "cluster",
 *     sourceIds: [_default&#46;id],
 *     severity: "INFO",
 *     eventCategories: [
 *         "configuration",
 *         "management",
 *         "monitoring",
 *         "security",
 *     ],
 *     tags: {
 *         Name: "default",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.redshift.Cluster("default",
 *     cluster_identifier="default",
 *     database_name="default")
 * default_topic = aws.sns.Topic("default", name="redshift-events")
 * default_event_subscription = aws.redshift.EventSubscription("default",
 *     name="redshift-event-sub",
 *     sns_topic_arn=default_topic.arn,
 *     source_type="cluster",
 *     source_ids=[default&#46;id],
 *     severity="INFO",
 *     event_categories=[
 *         "configuration",
 *         "management",
 *         "monitoring",
 *         "security",
 *     ],
 *     tags={
 *         "Name": "default",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.RedShift.Cluster("default", new()
 *     {
 *         ClusterIdentifier = "default",
 *         DatabaseName = "default",
 *     });
 *     var defaultTopic = new Aws.Sns.Topic("default", new()
 *     {
 *         Name = "redshift-events",
 *     });
 *     var defaultEventSubscription = new Aws.RedShift.EventSubscription("default", new()
 *     {
 *         Name = "redshift-event-sub",
 *         SnsTopicArn = defaultTopic.Arn,
 *         SourceType = "cluster",
 *         SourceIds = new[]
 *         {
 *             @default.Id,
 *         },
 *         Severity = "INFO",
 *         EventCategories = new[]
 *         {
 *             "configuration",
 *             "management",
 *             "monitoring",
 *             "security",
 *         },
 *         Tags =
 *         {
 *             { "Name", "default" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewCluster(ctx, "default", &redshift.ClusterArgs{
 * 			ClusterIdentifier: pulumi.String("default"),
 * 			DatabaseName:      pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTopic, err := sns.NewTopic(ctx, "default", &sns.TopicArgs{
 * 			Name: pulumi.String("redshift-events"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = redshift.NewEventSubscription(ctx, "default", &redshift.EventSubscriptionArgs{
 * 			Name:        pulumi.String("redshift-event-sub"),
 * 			SnsTopicArn: defaultTopic.Arn,
 * 			SourceType:  pulumi.String("cluster"),
 * 			SourceIds: pulumi.StringArray{
 * 				_default.ID(),
 * 			},
 * 			Severity: pulumi.String("INFO"),
 * 			EventCategories: pulumi.StringArray{
 * 				pulumi.String("configuration"),
 * 				pulumi.String("management"),
 * 				pulumi.String("monitoring"),
 * 				pulumi.String("security"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("default"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.redshift.EventSubscription;
 * import com.pulumi.aws.redshift.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("default")
 *             .databaseName("default")
 *             .build());
 *         var defaultTopic = new Topic("defaultTopic", TopicArgs.builder()
 *             .name("redshift-events")
 *             .build());
 *         var defaultEventSubscription = new EventSubscription("defaultEventSubscription", EventSubscriptionArgs.builder()
 *             .name("redshift-event-sub")
 *             .snsTopicArn(defaultTopic.arn())
 *             .sourceType("cluster")
 *             .sourceIds(default_.id())
 *             .severity("INFO")
 *             .eventCategories(
 *                 "configuration",
 *                 "management",
 *                 "monitoring",
 *                 "security")
 *             .tags(Map.of("Name", "default"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:redshift:Cluster
 *     properties:
 *       clusterIdentifier: default
 *       databaseName: default
 *   defaultTopic:
 *     type: aws:sns:Topic
 *     name: default
 *     properties:
 *       name: redshift-events
 *   defaultEventSubscription:
 *     type: aws:redshift:EventSubscription
 *     name: default
 *     properties:
 *       name: redshift-event-sub
 *       snsTopicArn: ${defaultTopic.arn}
 *       sourceType: cluster
 *       sourceIds:
 *         - ${default.id}
 *       severity: INFO
 *       eventCategories:
 *         - configuration
 *         - management
 *         - monitoring
 *         - security
 *       tags:
 *         Name: default
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Event Subscriptions using the `name`. For example:
 * ```sh
 * $ pulumi import aws:redshift/eventSubscription:EventSubscription default redshift-event-sub
 * ```
 * @property enabled A boolean flag to enable/disable the subscription. Defaults to `true`.
 * @property eventCategories A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html or run `aws redshift describe-event-categories`.
 * @property name The name of the Redshift event subscription.
 * @property severity The event severity to be published by the notification subscription. Valid options are `INFO` or `ERROR`. Default value of `INFO`.
 * @property snsTopicArn The ARN of the SNS topic to send events to.
 * @property sourceIds A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a `source_type` must also be specified.
 * @property sourceType The type of source that will be generating the events. Valid options are `cluster`, `cluster-parameter-group`, `cluster-security-group`, `cluster-snapshot`, or `scheduled-action`. If not set, all sources will be subscribed to.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EventSubscriptionArgs(
    public val enabled: Output<Boolean>? = null,
    public val eventCategories: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val severity: Output<String>? = null,
    public val snsTopicArn: Output<String>? = null,
    public val sourceIds: Output<List<String>>? = null,
    public val sourceType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.EventSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.redshift.EventSubscriptionArgs =
        com.pulumi.aws.redshift.EventSubscriptionArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .eventCategories(eventCategories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .severity(severity?.applyValue({ args0 -> args0 }))
            .snsTopicArn(snsTopicArn?.applyValue({ args0 -> args0 }))
            .sourceIds(sourceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventSubscriptionArgs].
 */
@PulumiTagMarker
public class EventSubscriptionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var eventCategories: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var severity: Output<String>? = null

    private var snsTopicArn: Output<String>? = null

    private var sourceIds: Output<List<String>>? = null

    private var sourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A boolean flag to enable/disable the subscription. Defaults to `true`.
     */
    @JvmName("oncvxruhgfaqcyub")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html or run `aws redshift describe-event-categories`.
     */
    @JvmName("qajbtmrqimogrkoe")
    public suspend fun eventCategories(`value`: Output<List<String>>) {
        this.eventCategories = value
    }

    @JvmName("rgvhmxxueqvtmddr")
    public suspend fun eventCategories(vararg values: Output<String>) {
        this.eventCategories = Output.all(values.asList())
    }

    /**
     * @param values A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html or run `aws redshift describe-event-categories`.
     */
    @JvmName("wgvoekbjneyxefwp")
    public suspend fun eventCategories(values: List<Output<String>>) {
        this.eventCategories = Output.all(values)
    }

    /**
     * @param value The name of the Redshift event subscription.
     */
    @JvmName("mxpumaifijhnjwwc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The event severity to be published by the notification subscription. Valid options are `INFO` or `ERROR`. Default value of `INFO`.
     */
    @JvmName("qaidgssoounqddvk")
    public suspend fun severity(`value`: Output<String>) {
        this.severity = value
    }

    /**
     * @param value The ARN of the SNS topic to send events to.
     */
    @JvmName("yaireahefhqejlfj")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a `source_type` must also be specified.
     */
    @JvmName("unuxaydanillbmnt")
    public suspend fun sourceIds(`value`: Output<List<String>>) {
        this.sourceIds = value
    }

    @JvmName("faoxcdoidiafsdjo")
    public suspend fun sourceIds(vararg values: Output<String>) {
        this.sourceIds = Output.all(values.asList())
    }

    /**
     * @param values A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a `source_type` must also be specified.
     */
    @JvmName("lqvhuwarbvnllxjq")
    public suspend fun sourceIds(values: List<Output<String>>) {
        this.sourceIds = Output.all(values)
    }

    /**
     * @param value The type of source that will be generating the events. Valid options are `cluster`, `cluster-parameter-group`, `cluster-security-group`, `cluster-snapshot`, or `scheduled-action`. If not set, all sources will be subscribed to.
     */
    @JvmName("imeyltneapoxdcrv")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rclfpifkoicttulr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A boolean flag to enable/disable the subscription. Defaults to `true`.
     */
    @JvmName("qdbaxwcnnseebcnx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html or run `aws redshift describe-event-categories`.
     */
    @JvmName("uoviuctbyprikxii")
    public suspend fun eventCategories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param values A list of event categories for a SourceType that you want to subscribe to. See https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html or run `aws redshift describe-event-categories`.
     */
    @JvmName("ndmsgaqsnsxcriqp")
    public suspend fun eventCategories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param value The name of the Redshift event subscription.
     */
    @JvmName("vyponmsfkmqspypw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The event severity to be published by the notification subscription. Valid options are `INFO` or `ERROR`. Default value of `INFO`.
     */
    @JvmName("davgycyhbwsftpft")
    public suspend fun severity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The ARN of the SNS topic to send events to.
     */
    @JvmName("adrbhfriekvambuo")
    public suspend fun snsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    /**
     * @param value A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a `source_type` must also be specified.
     */
    @JvmName("uqammiiifoxhuxjp")
    public suspend fun sourceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param values A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a `source_type` must also be specified.
     */
    @JvmName("nkvjsrddteoqdobg")
    public suspend fun sourceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param value The type of source that will be generating the events. Valid options are `cluster`, `cluster-parameter-group`, `cluster-security-group`, `cluster-snapshot`, or `scheduled-action`. If not set, all sources will be subscribed to.
     */
    @JvmName("vmdmjicymtfutvjh")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vjqeupxtlqtvbiaj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pngruqjdqigirqxo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EventSubscriptionArgs = EventSubscriptionArgs(
        enabled = enabled,
        eventCategories = eventCategories,
        name = name,
        severity = severity,
        snsTopicArn = snsTopicArn,
        sourceIds = sourceIds,
        sourceType = sourceType,
        tags = tags,
    )
}
