@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [HsmConfiguration].
 */
@PulumiTagMarker
public class HsmConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HsmConfigurationArgs = HsmConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HsmConfigurationArgsBuilder.() -> Unit) {
        val builder = HsmConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HsmConfiguration {
        val builtJavaResource = com.pulumi.aws.redshift.HsmConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HsmConfiguration(builtJavaResource)
    }
}

/**
 * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.HsmConfiguration("example", {
 *     description: "example",
 *     hsmConfigurationIdentifier: "example",
 *     hsmIpAddress: "10.0.0.1",
 *     hsmPartitionName: "aws",
 *     hsmPartitionPassword: "example",
 *     hsmServerPublicCertificate: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.HsmConfiguration("example",
 *     description="example",
 *     hsm_configuration_identifier="example",
 *     hsm_ip_address="10.0.0.1",
 *     hsm_partition_name="aws",
 *     hsm_partition_password="example",
 *     hsm_server_public_certificate="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.HsmConfiguration("example", new()
 *     {
 *         Description = "example",
 *         HsmConfigurationIdentifier = "example",
 *         HsmIpAddress = "10.0.0.1",
 *         HsmPartitionName = "aws",
 *         HsmPartitionPassword = "example",
 *         HsmServerPublicCertificate = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewHsmConfiguration(ctx, "example", &redshift.HsmConfigurationArgs{
 * 			Description:                pulumi.String("example"),
 * 			HsmConfigurationIdentifier: pulumi.String("example"),
 * 			HsmIpAddress:               pulumi.String("10.0.0.1"),
 * 			HsmPartitionName:           pulumi.String("aws"),
 * 			HsmPartitionPassword:       pulumi.String("example"),
 * 			HsmServerPublicCertificate: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.HsmConfiguration;
 * import com.pulumi.aws.redshift.HsmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HsmConfiguration("example", HsmConfigurationArgs.builder()
 *             .description("example")
 *             .hsmConfigurationIdentifier("example")
 *             .hsmIpAddress("10.0.0.1")
 *             .hsmPartitionName("aws")
 *             .hsmPartitionPassword("example")
 *             .hsmServerPublicCertificate("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:HsmConfiguration
 *     properties:
 *       description: example
 *       hsmConfigurationIdentifier: example
 *       hsmIpAddress: 10.0.0.1
 *       hsmPartitionName: aws
 *       hsmPartitionPassword: example
 *       hsmServerPublicCertificate: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift HSM Client Certificates using `hsm_configuration_identifier`. For example:
 * ```sh
 * $ pulumi import aws:redshift/hsmConfiguration:HsmConfiguration example example
 * ```
 */
public class HsmConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.redshift.HsmConfiguration,
) : KotlinCustomResource(javaResource, HsmConfigurationMapper) {
    /**
     * Amazon Resource Name (ARN) of the Hsm Client Certificate.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A text description of the HSM configuration to be created.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The identifier to be assigned to the new Amazon Redshift HSM configuration.
     */
    public val hsmConfigurationIdentifier: Output<String>
        get() = javaResource.hsmConfigurationIdentifier().applyValue({ args0 -> args0 })

    /**
     * The IP address that the Amazon Redshift cluster must use to access the HSM.
     */
    public val hsmIpAddress: Output<String>
        get() = javaResource.hsmIpAddress().applyValue({ args0 -> args0 })

    /**
     * The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.
     */
    public val hsmPartitionName: Output<String>
        get() = javaResource.hsmPartitionName().applyValue({ args0 -> args0 })

    /**
     * The password required to access the HSM partition.
     */
    public val hsmPartitionPassword: Output<String>
        get() = javaResource.hsmPartitionPassword().applyValue({ args0 -> args0 })

    /**
     * The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
     */
    public val hsmServerPublicCertificate: Output<String>
        get() = javaResource.hsmServerPublicCertificate().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object HsmConfigurationMapper : ResourceMapper<HsmConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.HsmConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): HsmConfiguration = HsmConfiguration(
        javaResource as
            com.pulumi.aws.redshift.HsmConfiguration,
    )
}

/**
 * @see [HsmConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HsmConfiguration].
 */
public suspend fun hsmConfiguration(
    name: String,
    block: suspend HsmConfigurationResourceBuilder.() -> Unit,
): HsmConfiguration {
    val builder = HsmConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HsmConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hsmConfiguration(name: String): HsmConfiguration {
    val builder = HsmConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
