@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.HsmConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.HsmConfiguration("example", {
 *     description: "example",
 *     hsmConfigurationIdentifier: "example",
 *     hsmIpAddress: "10.0.0.1",
 *     hsmPartitionName: "aws",
 *     hsmPartitionPassword: "example",
 *     hsmServerPublicCertificate: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.HsmConfiguration("example",
 *     description="example",
 *     hsm_configuration_identifier="example",
 *     hsm_ip_address="10.0.0.1",
 *     hsm_partition_name="aws",
 *     hsm_partition_password="example",
 *     hsm_server_public_certificate="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.HsmConfiguration("example", new()
 *     {
 *         Description = "example",
 *         HsmConfigurationIdentifier = "example",
 *         HsmIpAddress = "10.0.0.1",
 *         HsmPartitionName = "aws",
 *         HsmPartitionPassword = "example",
 *         HsmServerPublicCertificate = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewHsmConfiguration(ctx, "example", &redshift.HsmConfigurationArgs{
 * 			Description:                pulumi.String("example"),
 * 			HsmConfigurationIdentifier: pulumi.String("example"),
 * 			HsmIpAddress:               pulumi.String("10.0.0.1"),
 * 			HsmPartitionName:           pulumi.String("aws"),
 * 			HsmPartitionPassword:       pulumi.String("example"),
 * 			HsmServerPublicCertificate: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.HsmConfiguration;
 * import com.pulumi.aws.redshift.HsmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HsmConfiguration("example", HsmConfigurationArgs.builder()
 *             .description("example")
 *             .hsmConfigurationIdentifier("example")
 *             .hsmIpAddress("10.0.0.1")
 *             .hsmPartitionName("aws")
 *             .hsmPartitionPassword("example")
 *             .hsmServerPublicCertificate("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:HsmConfiguration
 *     properties:
 *       description: example
 *       hsmConfigurationIdentifier: example
 *       hsmIpAddress: 10.0.0.1
 *       hsmPartitionName: aws
 *       hsmPartitionPassword: example
 *       hsmServerPublicCertificate: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift HSM Client Certificates using `hsm_configuration_identifier`. For example:
 * ```sh
 * $ pulumi import aws:redshift/hsmConfiguration:HsmConfiguration example example
 * ```
 * @property description A text description of the HSM configuration to be created.
 * @property hsmConfigurationIdentifier The identifier to be assigned to the new Amazon Redshift HSM configuration.
 * @property hsmIpAddress The IP address that the Amazon Redshift cluster must use to access the HSM.
 * @property hsmPartitionName The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.
 * @property hsmPartitionPassword The password required to access the HSM partition.
 * @property hsmServerPublicCertificate The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class HsmConfigurationArgs(
    public val description: Output<String>? = null,
    public val hsmConfigurationIdentifier: Output<String>? = null,
    public val hsmIpAddress: Output<String>? = null,
    public val hsmPartitionName: Output<String>? = null,
    public val hsmPartitionPassword: Output<String>? = null,
    public val hsmServerPublicCertificate: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.HsmConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.redshift.HsmConfigurationArgs =
        com.pulumi.aws.redshift.HsmConfigurationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .hsmConfigurationIdentifier(hsmConfigurationIdentifier?.applyValue({ args0 -> args0 }))
            .hsmIpAddress(hsmIpAddress?.applyValue({ args0 -> args0 }))
            .hsmPartitionName(hsmPartitionName?.applyValue({ args0 -> args0 }))
            .hsmPartitionPassword(hsmPartitionPassword?.applyValue({ args0 -> args0 }))
            .hsmServerPublicCertificate(hsmServerPublicCertificate?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [HsmConfigurationArgs].
 */
@PulumiTagMarker
public class HsmConfigurationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var hsmConfigurationIdentifier: Output<String>? = null

    private var hsmIpAddress: Output<String>? = null

    private var hsmPartitionName: Output<String>? = null

    private var hsmPartitionPassword: Output<String>? = null

    private var hsmServerPublicCertificate: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A text description of the HSM configuration to be created.
     */
    @JvmName("oakbqvtuarocmrex")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The identifier to be assigned to the new Amazon Redshift HSM configuration.
     */
    @JvmName("hkehmnxckdbtjylu")
    public suspend fun hsmConfigurationIdentifier(`value`: Output<String>) {
        this.hsmConfigurationIdentifier = value
    }

    /**
     * @param value The IP address that the Amazon Redshift cluster must use to access the HSM.
     */
    @JvmName("bpdufxpjhiledmtn")
    public suspend fun hsmIpAddress(`value`: Output<String>) {
        this.hsmIpAddress = value
    }

    /**
     * @param value The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.
     */
    @JvmName("mcfcjvjxdrnectqr")
    public suspend fun hsmPartitionName(`value`: Output<String>) {
        this.hsmPartitionName = value
    }

    /**
     * @param value The password required to access the HSM partition.
     */
    @JvmName("rbgsqxuhovyjqwru")
    public suspend fun hsmPartitionPassword(`value`: Output<String>) {
        this.hsmPartitionPassword = value
    }

    /**
     * @param value The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
     */
    @JvmName("vgaehqyfmijcdrfo")
    public suspend fun hsmServerPublicCertificate(`value`: Output<String>) {
        this.hsmServerPublicCertificate = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lqvxproqmbcxolvs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A text description of the HSM configuration to be created.
     */
    @JvmName("xfwgrhyyaefghpqi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The identifier to be assigned to the new Amazon Redshift HSM configuration.
     */
    @JvmName("xlogeejvyxwgmffm")
    public suspend fun hsmConfigurationIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmConfigurationIdentifier = mapped
    }

    /**
     * @param value The IP address that the Amazon Redshift cluster must use to access the HSM.
     */
    @JvmName("fiordwxixkjldpfb")
    public suspend fun hsmIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmIpAddress = mapped
    }

    /**
     * @param value The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.
     */
    @JvmName("tbulmkwhdgvuqhsf")
    public suspend fun hsmPartitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmPartitionName = mapped
    }

    /**
     * @param value The password required to access the HSM partition.
     */
    @JvmName("flxggabwhkgdlcis")
    public suspend fun hsmPartitionPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmPartitionPassword = mapped
    }

    /**
     * @param value The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
     */
    @JvmName("hmvvcmtufcbdbisi")
    public suspend fun hsmServerPublicCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmServerPublicCertificate = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eqktvtqimshhkicd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tssmtxofcmxylksr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): HsmConfigurationArgs = HsmConfigurationArgs(
        description = description,
        hsmConfigurationIdentifier = hsmConfigurationIdentifier,
        hsmIpAddress = hsmIpAddress,
        hsmPartitionName = hsmPartitionName,
        hsmPartitionPassword = hsmPartitionPassword,
        hsmServerPublicCertificate = hsmServerPublicCertificate,
        tags = tags,
    )
}
