@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Logging].
 */
@PulumiTagMarker
public class LoggingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoggingArgs = LoggingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoggingArgsBuilder.() -> Unit) {
        val builder = LoggingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Logging {
        val builtJavaResource = com.pulumi.aws.redshift.Logging(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Logging(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Redshift Logging configuration.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.Logging("example", {
 *     clusterIdentifier: exampleAwsRedshiftCluster.id,
 *     logDestinationType: "cloudwatch",
 *     logExports: [
 *         "connectionlog",
 *         "userlog",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.Logging("example",
 *     cluster_identifier=example_aws_redshift_cluster["id"],
 *     log_destination_type="cloudwatch",
 *     log_exports=[
 *         "connectionlog",
 *         "userlog",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.Logging("example", new()
 *     {
 *         ClusterIdentifier = exampleAwsRedshiftCluster.Id,
 *         LogDestinationType = "cloudwatch",
 *         LogExports = new[]
 *         {
 *             "connectionlog",
 *             "userlog",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewLogging(ctx, "example", &redshift.LoggingArgs{
 * 			ClusterIdentifier:  pulumi.Any(exampleAwsRedshiftCluster.Id),
 * 			LogDestinationType: pulumi.String("cloudwatch"),
 * 			LogExports: pulumi.StringArray{
 * 				pulumi.String("connectionlog"),
 * 				pulumi.String("userlog"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Logging;
 * import com.pulumi.aws.redshift.LoggingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Logging("example", LoggingArgs.builder()
 *             .clusterIdentifier(exampleAwsRedshiftCluster.id())
 *             .logDestinationType("cloudwatch")
 *             .logExports(
 *                 "connectionlog",
 *                 "userlog")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:Logging
 *     properties:
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.id}
 *       logDestinationType: cloudwatch
 *       logExports:
 *         - connectionlog
 *         - userlog
 * ```
 * <!--End PulumiCodeChooser -->
 * ### S3 Destination Type
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.Logging("example", {
 *     clusterIdentifier: exampleAwsRedshiftCluster.id,
 *     logDestinationType: "s3",
 *     bucketName: exampleAwsS3Bucket.id,
 *     s3KeyPrefix: "example-prefix/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.Logging("example",
 *     cluster_identifier=example_aws_redshift_cluster["id"],
 *     log_destination_type="s3",
 *     bucket_name=example_aws_s3_bucket["id"],
 *     s3_key_prefix="example-prefix/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.Logging("example", new()
 *     {
 *         ClusterIdentifier = exampleAwsRedshiftCluster.Id,
 *         LogDestinationType = "s3",
 *         BucketName = exampleAwsS3Bucket.Id,
 *         S3KeyPrefix = "example-prefix/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewLogging(ctx, "example", &redshift.LoggingArgs{
 * 			ClusterIdentifier:  pulumi.Any(exampleAwsRedshiftCluster.Id),
 * 			LogDestinationType: pulumi.String("s3"),
 * 			BucketName:         pulumi.Any(exampleAwsS3Bucket.Id),
 * 			S3KeyPrefix:        pulumi.String("example-prefix/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Logging;
 * import com.pulumi.aws.redshift.LoggingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Logging("example", LoggingArgs.builder()
 *             .clusterIdentifier(exampleAwsRedshiftCluster.id())
 *             .logDestinationType("s3")
 *             .bucketName(exampleAwsS3Bucket.id())
 *             .s3KeyPrefix("example-prefix/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:Logging
 *     properties:
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.id}
 *       logDestinationType: s3
 *       bucketName: ${exampleAwsS3Bucket.id}
 *       s3KeyPrefix: example-prefix/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Logging using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshift/logging:Logging example cluster-id-12345678
 * ```
 */
public class Logging internal constructor(
    override val javaResource: com.pulumi.aws.redshift.Logging,
) : KotlinCustomResource(javaResource, LoggingMapper) {
    /**
     * Name of an existing S3 bucket where the log files are to be stored. Required when `log_destination_type` is `s3`. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions. For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     */
    public val bucketName: Output<String>?
        get() = javaResource.bucketName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the source cluster.
     * The following arguments are optional:
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * Log destination type. Valid values are `s3` and `cloudwatch`.
     */
    public val logDestinationType: Output<String>?
        get() = javaResource.logDestinationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Collection of exported log types. Required when `log_destination_type` is `cloudwatch`. Valid values are `connectionlog`, `useractivitylog`, and `userlog`.
     */
    public val logExports: Output<List<String>>?
        get() = javaResource.logExports().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Prefix applied to the log file names.
     */
    public val s3KeyPrefix: Output<String>?
        get() = javaResource.s3KeyPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object LoggingMapper : ResourceMapper<Logging> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.Logging::class == javaResource::class

    override fun map(javaResource: Resource): Logging = Logging(
        javaResource as
            com.pulumi.aws.redshift.Logging,
    )
}

/**
 * @see [Logging].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Logging].
 */
public suspend fun logging(name: String, block: suspend LoggingResourceBuilder.() -> Unit): Logging {
    val builder = LoggingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Logging].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logging(name: String): Logging {
    val builder = LoggingResourceBuilder()
    builder.name(name)
    return builder.build()
}
