@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.kotlin.outputs.ParameterGroupParameter
import com.pulumi.aws.redshift.kotlin.outputs.ParameterGroupParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ParameterGroup].
 */
@PulumiTagMarker
public class ParameterGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ParameterGroupArgs = ParameterGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ParameterGroupArgsBuilder.() -> Unit) {
        val builder = ParameterGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ParameterGroup {
        val builtJavaResource = com.pulumi.aws.redshift.ParameterGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ParameterGroup(builtJavaResource)
    }
}

/**
 * Provides a Redshift Cluster parameter group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bar = new aws.redshift.ParameterGroup("bar", {
 *     name: "parameter-group-test",
 *     family: "redshift-1.0",
 *     parameters: [
 *         {
 *             name: "require_ssl",
 *             value: "true",
 *         },
 *         {
 *             name: "query_group",
 *             value: "example",
 *         },
 *         {
 *             name: "enable_user_activity_logging",
 *             value: "true",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bar = aws.redshift.ParameterGroup("bar",
 *     name="parameter-group-test",
 *     family="redshift-1.0",
 *     parameters=[
 *         {
 *             "name": "require_ssl",
 *             "value": "true",
 *         },
 *         {
 *             "name": "query_group",
 *             "value": "example",
 *         },
 *         {
 *             "name": "enable_user_activity_logging",
 *             "value": "true",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new Aws.RedShift.ParameterGroup("bar", new()
 *     {
 *         Name = "parameter-group-test",
 *         Family = "redshift-1.0",
 *         Parameters = new[]
 *         {
 *             new Aws.RedShift.Inputs.ParameterGroupParameterArgs
 *             {
 *                 Name = "require_ssl",
 *                 Value = "true",
 *             },
 *             new Aws.RedShift.Inputs.ParameterGroupParameterArgs
 *             {
 *                 Name = "query_group",
 *                 Value = "example",
 *             },
 *             new Aws.RedShift.Inputs.ParameterGroupParameterArgs
 *             {
 *                 Name = "enable_user_activity_logging",
 *                 Value = "true",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewParameterGroup(ctx, "bar", &redshift.ParameterGroupArgs{
 * 			Name:   pulumi.String("parameter-group-test"),
 * 			Family: pulumi.String("redshift-1.0"),
 * 			Parameters: redshift.ParameterGroupParameterArray{
 * 				&redshift.ParameterGroupParameterArgs{
 * 					Name:  pulumi.String("require_ssl"),
 * 					Value: pulumi.String("true"),
 * 				},
 * 				&redshift.ParameterGroupParameterArgs{
 * 					Name:  pulumi.String("query_group"),
 * 					Value: pulumi.String("example"),
 * 				},
 * 				&redshift.ParameterGroupParameterArgs{
 * 					Name:  pulumi.String("enable_user_activity_logging"),
 * 					Value: pulumi.String("true"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.ParameterGroup;
 * import com.pulumi.aws.redshift.ParameterGroupArgs;
 * import com.pulumi.aws.redshift.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new ParameterGroup("bar", ParameterGroupArgs.builder()
 *             .name("parameter-group-test")
 *             .family("redshift-1.0")
 *             .parameters(
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("require_ssl")
 *                     .value("true")
 *                     .build(),
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("query_group")
 *                     .value("example")
 *                     .build(),
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("enable_user_activity_logging")
 *                     .value("true")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:redshift:ParameterGroup
 *     properties:
 *       name: parameter-group-test
 *       family: redshift-1.0
 *       parameters:
 *         - name: require_ssl
 *           value: 'true'
 *         - name: query_group
 *           value: example
 *         - name: enable_user_activity_logging
 *           value: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Parameter Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:redshift/parameterGroup:ParameterGroup paramgroup1 parameter-group-test-pulumi
 * ```
 */
public class ParameterGroup internal constructor(
    override val javaResource: com.pulumi.aws.redshift.ParameterGroup,
) : KotlinCustomResource(javaResource, ParameterGroupMapper) {
    /**
     * Amazon Resource Name (ARN) of parameter group
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the Redshift parameter group. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The family of the Redshift parameter group.
     */
    public val family: Output<String>
        get() = javaResource.family().applyValue({ args0 -> args0 })

    /**
     * The name of the Redshift parameter.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of Redshift parameters to apply.
     */
    public val parameters: Output<List<ParameterGroupParameter>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * You can read more about the parameters that Redshift supports in the [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ParameterGroupMapper : ResourceMapper<ParameterGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.ParameterGroup::class == javaResource::class

    override fun map(javaResource: Resource): ParameterGroup = ParameterGroup(
        javaResource as
            com.pulumi.aws.redshift.ParameterGroup,
    )
}

/**
 * @see [ParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ParameterGroup].
 */
public suspend fun parameterGroup(
    name: String,
    block: suspend ParameterGroupResourceBuilder.() -> Unit,
): ParameterGroup {
    val builder = ParameterGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun parameterGroup(name: String): ParameterGroup {
    val builder = ParameterGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
