@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.ParameterGroupArgs.builder
import com.pulumi.aws.redshift.kotlin.inputs.ParameterGroupParameterArgs
import com.pulumi.aws.redshift.kotlin.inputs.ParameterGroupParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Redshift Cluster parameter group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bar = new aws.redshift.ParameterGroup("bar", {
 *     name: "parameter-group-test",
 *     family: "redshift-1.0",
 *     parameters: [
 *         {
 *             name: "require_ssl",
 *             value: "true",
 *         },
 *         {
 *             name: "query_group",
 *             value: "example",
 *         },
 *         {
 *             name: "enable_user_activity_logging",
 *             value: "true",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bar = aws.redshift.ParameterGroup("bar",
 *     name="parameter-group-test",
 *     family="redshift-1.0",
 *     parameters=[
 *         {
 *             "name": "require_ssl",
 *             "value": "true",
 *         },
 *         {
 *             "name": "query_group",
 *             "value": "example",
 *         },
 *         {
 *             "name": "enable_user_activity_logging",
 *             "value": "true",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new Aws.RedShift.ParameterGroup("bar", new()
 *     {
 *         Name = "parameter-group-test",
 *         Family = "redshift-1.0",
 *         Parameters = new[]
 *         {
 *             new Aws.RedShift.Inputs.ParameterGroupParameterArgs
 *             {
 *                 Name = "require_ssl",
 *                 Value = "true",
 *             },
 *             new Aws.RedShift.Inputs.ParameterGroupParameterArgs
 *             {
 *                 Name = "query_group",
 *                 Value = "example",
 *             },
 *             new Aws.RedShift.Inputs.ParameterGroupParameterArgs
 *             {
 *                 Name = "enable_user_activity_logging",
 *                 Value = "true",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewParameterGroup(ctx, "bar", &redshift.ParameterGroupArgs{
 * 			Name:   pulumi.String("parameter-group-test"),
 * 			Family: pulumi.String("redshift-1.0"),
 * 			Parameters: redshift.ParameterGroupParameterArray{
 * 				&redshift.ParameterGroupParameterArgs{
 * 					Name:  pulumi.String("require_ssl"),
 * 					Value: pulumi.String("true"),
 * 				},
 * 				&redshift.ParameterGroupParameterArgs{
 * 					Name:  pulumi.String("query_group"),
 * 					Value: pulumi.String("example"),
 * 				},
 * 				&redshift.ParameterGroupParameterArgs{
 * 					Name:  pulumi.String("enable_user_activity_logging"),
 * 					Value: pulumi.String("true"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.ParameterGroup;
 * import com.pulumi.aws.redshift.ParameterGroupArgs;
 * import com.pulumi.aws.redshift.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new ParameterGroup("bar", ParameterGroupArgs.builder()
 *             .name("parameter-group-test")
 *             .family("redshift-1.0")
 *             .parameters(
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("require_ssl")
 *                     .value("true")
 *                     .build(),
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("query_group")
 *                     .value("example")
 *                     .build(),
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("enable_user_activity_logging")
 *                     .value("true")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:redshift:ParameterGroup
 *     properties:
 *       name: parameter-group-test
 *       family: redshift-1.0
 *       parameters:
 *         - name: require_ssl
 *           value: 'true'
 *         - name: query_group
 *           value: example
 *         - name: enable_user_activity_logging
 *           value: 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Parameter Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:redshift/parameterGroup:ParameterGroup paramgroup1 parameter-group-test-pulumi
 * ```
 * @property description The description of the Redshift parameter group. Defaults to "Managed by Pulumi".
 * @property family The family of the Redshift parameter group.
 * @property name The name of the Redshift parameter.
 * @property parameters A list of Redshift parameters to apply.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * You can read more about the parameters that Redshift supports in the [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
 */
public data class ParameterGroupArgs(
    public val description: Output<String>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<List<ParameterGroupParameterArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.ParameterGroupArgs> {
    override fun toJava(): com.pulumi.aws.redshift.ParameterGroupArgs =
        com.pulumi.aws.redshift.ParameterGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ParameterGroupArgs].
 */
@PulumiTagMarker
public class ParameterGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<List<ParameterGroupParameterArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the Redshift parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("ywdphapbsofrxpnv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The family of the Redshift parameter group.
     */
    @JvmName("qrhhnxqdyhofuroj")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the Redshift parameter.
     */
    @JvmName("qnfkaeedbrvffyeh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of Redshift parameters to apply.
     */
    @JvmName("bsdonddgbudobtoi")
    public suspend fun parameters(`value`: Output<List<ParameterGroupParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("bglxbrombsbfbosl")
    public suspend fun parameters(vararg values: Output<ParameterGroupParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values A list of Redshift parameters to apply.
     */
    @JvmName("ptatpgrhwidpluox")
    public suspend fun parameters(values: List<Output<ParameterGroupParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * You can read more about the parameters that Redshift supports in the [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
     */
    @JvmName("gddyiufxocacqwyt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the Redshift parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("fotgghqugwldavph")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The family of the Redshift parameter group.
     */
    @JvmName("lvjklrmiijcibjok")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the Redshift parameter.
     */
    @JvmName("hsedvqpagobefnbh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of Redshift parameters to apply.
     */
    @JvmName("evlwvyycpbaaglyr")
    public suspend fun parameters(`value`: List<ParameterGroupParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument A list of Redshift parameters to apply.
     */
    @JvmName("fbsubamxwebthxqf")
    public suspend fun parameters(argument: List<suspend ParameterGroupParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of Redshift parameters to apply.
     */
    @JvmName("agoybhtpelofaaob")
    public suspend fun parameters(vararg argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of Redshift parameters to apply.
     */
    @JvmName("qhiufwdpajgscjxv")
    public suspend fun parameters(argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ParameterGroupParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values A list of Redshift parameters to apply.
     */
    @JvmName("oyujrhfmdkvdeadq")
    public suspend fun parameters(vararg values: ParameterGroupParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * You can read more about the parameters that Redshift supports in the [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
     */
    @JvmName("rnqnumnbdykpwjab")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * You can read more about the parameters that Redshift supports in the [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
     */
    @JvmName("vnlnpsdudtnaufwv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ParameterGroupArgs = ParameterGroupArgs(
        description = description,
        family = family,
        name = name,
        parameters = parameters,
        tags = tags,
    )
}
