@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.PartnerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Partner Integration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.Partner("example", {
 *     clusterIdentifier: exampleAwsRedshiftCluster.id,
 *     accountId: "1234567910",
 *     databaseName: exampleAwsRedshiftCluster.databaseName,
 *     partnerName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.Partner("example",
 *     cluster_identifier=example_aws_redshift_cluster["id"],
 *     account_id="1234567910",
 *     database_name=example_aws_redshift_cluster["databaseName"],
 *     partner_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.Partner("example", new()
 *     {
 *         ClusterIdentifier = exampleAwsRedshiftCluster.Id,
 *         AccountId = "1234567910",
 *         DatabaseName = exampleAwsRedshiftCluster.DatabaseName,
 *         PartnerName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewPartner(ctx, "example", &redshift.PartnerArgs{
 * 			ClusterIdentifier: pulumi.Any(exampleAwsRedshiftCluster.Id),
 * 			AccountId:         pulumi.String("1234567910"),
 * 			DatabaseName:      pulumi.Any(exampleAwsRedshiftCluster.DatabaseName),
 * 			PartnerName:       pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Partner;
 * import com.pulumi.aws.redshift.PartnerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Partner("example", PartnerArgs.builder()
 *             .clusterIdentifier(exampleAwsRedshiftCluster.id())
 *             .accountId(1234567910)
 *             .databaseName(exampleAwsRedshiftCluster.databaseName())
 *             .partnerName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:Partner
 *     properties:
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.id}
 *       accountId: 1.23456791e+09
 *       databaseName: ${exampleAwsRedshiftCluster.databaseName}
 *       partnerName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift usage limits using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshift/partner:Partner example 01234567910:cluster-example-id:example:example
 * ```
 * @property accountId The Amazon Web Services account ID that owns the cluster.
 * @property clusterIdentifier The cluster identifier of the cluster that receives data from the partner.
 * @property databaseName The name of the database that receives data from the partner.
 * @property partnerName The name of the partner that is authorized to send data.
 */
public data class PartnerArgs(
    public val accountId: Output<String>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val partnerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.PartnerArgs> {
    override fun toJava(): com.pulumi.aws.redshift.PartnerArgs =
        com.pulumi.aws.redshift.PartnerArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .partnerName(partnerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartnerArgs].
 */
@PulumiTagMarker
public class PartnerArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var clusterIdentifier: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var partnerName: Output<String>? = null

    /**
     * @param value The Amazon Web Services account ID that owns the cluster.
     */
    @JvmName("woghxthvqvjespua")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The cluster identifier of the cluster that receives data from the partner.
     */
    @JvmName("xfbbfgbpxghctuck")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The name of the database that receives data from the partner.
     */
    @JvmName("cxaqtdbhplfyvgdu")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the partner that is authorized to send data.
     */
    @JvmName("xtysaaqwjeswcbny")
    public suspend fun partnerName(`value`: Output<String>) {
        this.partnerName = value
    }

    /**
     * @param value The Amazon Web Services account ID that owns the cluster.
     */
    @JvmName("tcvobhnffhwmcgxl")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The cluster identifier of the cluster that receives data from the partner.
     */
    @JvmName("dbttquyjpruuawap")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The name of the database that receives data from the partner.
     */
    @JvmName("wojbqkgearwfsyje")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the partner that is authorized to send data.
     */
    @JvmName("wkfevipynwgyouhw")
    public suspend fun partnerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerName = mapped
    }

    internal fun build(): PartnerArgs = PartnerArgs(
        accountId = accountId,
        clusterIdentifier = clusterIdentifier,
        databaseName = databaseName,
        partnerName = partnerName,
    )
}
