@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.RedshiftFunctions.getClusterCredentialsPlain
import com.pulumi.aws.redshift.RedshiftFunctions.getClusterPlain
import com.pulumi.aws.redshift.RedshiftFunctions.getDataSharesPlain
import com.pulumi.aws.redshift.RedshiftFunctions.getOrderableClusterPlain
import com.pulumi.aws.redshift.RedshiftFunctions.getProducerDataSharesPlain
import com.pulumi.aws.redshift.RedshiftFunctions.getServiceAccountPlain
import com.pulumi.aws.redshift.RedshiftFunctions.getSubnetGroupPlain
import com.pulumi.aws.redshift.kotlin.inputs.GetClusterCredentialsPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetClusterCredentialsPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.inputs.GetDataSharesDataShare
import com.pulumi.aws.redshift.kotlin.inputs.GetDataSharesPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetDataSharesPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.inputs.GetOrderableClusterPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetOrderableClusterPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.inputs.GetProducerDataSharesDataShare
import com.pulumi.aws.redshift.kotlin.inputs.GetProducerDataSharesPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetProducerDataSharesPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.inputs.GetServiceAccountPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetServiceAccountPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.inputs.GetSubnetGroupPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetSubnetGroupPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.outputs.GetClusterCredentialsResult
import com.pulumi.aws.redshift.kotlin.outputs.GetClusterResult
import com.pulumi.aws.redshift.kotlin.outputs.GetDataSharesResult
import com.pulumi.aws.redshift.kotlin.outputs.GetOrderableClusterResult
import com.pulumi.aws.redshift.kotlin.outputs.GetProducerDataSharesResult
import com.pulumi.aws.redshift.kotlin.outputs.GetServiceAccountResult
import com.pulumi.aws.redshift.kotlin.outputs.GetSubnetGroupResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.redshift.kotlin.outputs.GetClusterCredentialsResult.Companion.toKotlin as getClusterCredentialsResultToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.GetDataSharesResult.Companion.toKotlin as getDataSharesResultToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.GetOrderableClusterResult.Companion.toKotlin as getOrderableClusterResultToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.GetProducerDataSharesResult.Companion.toKotlin as getProducerDataSharesResultToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.GetServiceAccountResult.Companion.toKotlin as getServiceAccountResultToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.GetSubnetGroupResult.Companion.toKotlin as getSubnetGroupResultToKotlin

public object RedshiftFunctions {
    /**
     * Provides details about a specific redshift cluster.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterArgs;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterIdentifier("example-cluster")
     *             .build());
     *         var exampleStream = new FirehoseDeliveryStream("exampleStream", FirehoseDeliveryStreamArgs.builder()
     *             .name("kinesis-firehose-example-stream")
     *             .destination("redshift")
     *             .redshiftConfiguration(FirehoseDeliveryStreamRedshiftConfigurationArgs.builder()
     *                 .roleArn(firehoseRole.arn())
     *                 .clusterJdbcurl(String.format("jdbc:redshift://%s/%s", example.applyValue(getClusterResult -> getClusterResult.endpoint()),example.applyValue(getClusterResult -> getClusterResult.databaseName())))
     *                 .username("exampleuser")
     *                 .password("Exampl3Pass")
     *                 .dataTableName("example-table")
     *                 .copyOptions("delimiter '|'")
     *                 .dataTableColumns("example-col")
     *                 .s3Configuration(FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs.builder()
     *                     .roleArn(firehoseRole.arn())
     *                     .bucketArn(bucket.arn())
     *                     .bufferSize(10)
     *                     .bufferInterval(400)
     *                     .compressionFormat("GZIP")
     *                     .build())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   exampleStream:
     *     type: aws:kinesis:FirehoseDeliveryStream
     *     name: example_stream
     *     properties:
     *       name: kinesis-firehose-example-stream
     *       destination: redshift
     *       redshiftConfiguration:
     *         roleArn: ${firehoseRole.arn}
     *         clusterJdbcurl: jdbc:redshift://${example.endpoint}/${example.databaseName}
     *         username: exampleuser
     *         password: Exampl3Pass
     *         dataTableName: example-table
     *         copyOptions: delimiter '|'
     *         dataTableColumns: example-col
     *         s3Configuration:
     *           roleArn: ${firehoseRole.arn}
     *           bucketArn: ${bucket.arn}
     *           bufferSize: 10
     *           bufferInterval: 400
     *           compressionFormat: GZIP
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:redshift:getCluster
     *       Arguments:
     *         clusterIdentifier: example-cluster
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterIdentifier Cluster identifier
     * @param tags Tags associated to the cluster
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(clusterIdentifier: String, tags: Map<String, String>? = null): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterIdentifier = clusterIdentifier,
            tags = tags,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit): GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides redshift cluster temporary credentials.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.redshift.getClusterCredentials({
     *     clusterIdentifier: exampleAwsRedshiftCluster.clusterIdentifier,
     *     dbUser: exampleAwsRedshiftCluster.masterUsername,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.redshift.get_cluster_credentials(cluster_identifier=example_aws_redshift_cluster["clusterIdentifier"],
     *     db_user=example_aws_redshift_cluster["masterUsername"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.RedShift.GetClusterCredentials.Invoke(new()
     *     {
     *         ClusterIdentifier = exampleAwsRedshiftCluster.ClusterIdentifier,
     *         DbUser = exampleAwsRedshiftCluster.MasterUsername,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := redshift.GetClusterCredentials(ctx, &redshift.GetClusterCredentialsArgs{
     * 			ClusterIdentifier: exampleAwsRedshiftCluster.ClusterIdentifier,
     * 			DbUser:            exampleAwsRedshiftCluster.MasterUsername,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterCredentialsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getClusterCredentials(GetClusterCredentialsArgs.builder()
     *             .clusterIdentifier(exampleAwsRedshiftCluster.clusterIdentifier())
     *             .dbUser(exampleAwsRedshiftCluster.masterUsername())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:redshift:getClusterCredentials
     *       Arguments:
     *         clusterIdentifier: ${exampleAwsRedshiftCluster.clusterIdentifier}
     *         dbUser: ${exampleAwsRedshiftCluster.masterUsername}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusterCredentials.
     * @return A collection of values returned by getClusterCredentials.
     */
    public suspend fun getClusterCredentials(argument: GetClusterCredentialsPlainArgs): GetClusterCredentialsResult =
        getClusterCredentialsResultToKotlin(getClusterCredentialsPlain(argument.toJava()).await())

    /**
     * @see [getClusterCredentials].
     * @param autoCreate Create a database user with the name specified for the user named in `db_user` if one does not exist.
     * @param clusterIdentifier Unique identifier of the cluster that contains the database for which your are requesting credentials.
     * @param dbGroups List of the names of existing database groups that the user named in `db_user` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to `PUBLIC`.
     * @param dbName Name of a database that DbUser is authorized to log on to. If `db_name` is not specified, `db_user` can log on to any existing database.
     * @param dbUser Name of a database user. If a user name matching `db_user` exists in the database, the temporary user credentials have the same permissions as the  existing user. If `db_user` doesn't exist in the database and `auto_create` is `True`, a new user is created using the value for `db_user` with `PUBLIC` permissions.  If a database user matching the value for `db_user` doesn't exist and `not` is `False`, then the command succeeds but the connection attempt will fail because the user doesn't exist in the database.
     * @param durationSeconds The number of seconds until the returned temporary password expires. Valid values are between `900` and `3600`. Default value is `900`.
     * @return A collection of values returned by getClusterCredentials.
     */
    public suspend fun getClusterCredentials(
        autoCreate: Boolean? = null,
        clusterIdentifier: String,
        dbGroups: List<String>? = null,
        dbName: String? = null,
        dbUser: String,
        durationSeconds: Int? = null,
    ): GetClusterCredentialsResult {
        val argument = GetClusterCredentialsPlainArgs(
            autoCreate = autoCreate,
            clusterIdentifier = clusterIdentifier,
            dbGroups = dbGroups,
            dbName = dbName,
            dbUser = dbUser,
            durationSeconds = durationSeconds,
        )
        return getClusterCredentialsResultToKotlin(getClusterCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetClusterCredentialsPlainArgs].
     * @return A collection of values returned by getClusterCredentials.
     */
    public suspend fun getClusterCredentials(argument: suspend GetClusterCredentialsPlainArgsBuilder.() -> Unit): GetClusterCredentialsResult {
        val builder = GetClusterCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterCredentialsResultToKotlin(getClusterCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing AWS Redshift Data Shares.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.redshift.getDataShares({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.redshift.get_data_shares()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.RedShift.GetDataShares.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := redshift.GetDataShares(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetDataSharesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getDataShares();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:redshift:getDataShares
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDataShares.
     * @return A collection of values returned by getDataShares.
     */
    public suspend fun getDataShares(argument: GetDataSharesPlainArgs): GetDataSharesResult =
        getDataSharesResultToKotlin(getDataSharesPlain(argument.toJava()).await())

    /**
     * @see [getDataShares].
     * @param dataShares An array of all data shares in the current region. See `data_shares` below.
     * @return A collection of values returned by getDataShares.
     */
    public suspend fun getDataShares(dataShares: List<GetDataSharesDataShare>? = null): GetDataSharesResult {
        val argument = GetDataSharesPlainArgs(
            dataShares = dataShares,
        )
        return getDataSharesResultToKotlin(getDataSharesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataShares].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetDataSharesPlainArgs].
     * @return A collection of values returned by getDataShares.
     */
    public suspend fun getDataShares(argument: suspend GetDataSharesPlainArgsBuilder.() -> Unit): GetDataSharesResult {
        val builder = GetDataSharesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataSharesResultToKotlin(getDataSharesPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about Redshift Orderable Clusters and valid parameter combinations.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.redshift.getOrderableCluster({
     *     clusterType: "multi-node",
     *     preferredNodeTypes: [
     *         "dc2.large",
     *         "ds2.xlarge",
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.redshift.get_orderable_cluster(cluster_type="multi-node",
     *     preferred_node_types=[
     *         "dc2.large",
     *         "ds2.xlarge",
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.RedShift.GetOrderableCluster.Invoke(new()
     *     {
     *         ClusterType = "multi-node",
     *         PreferredNodeTypes = new[]
     *         {
     *             "dc2.large",
     *             "ds2.xlarge",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := redshift.GetOrderableCluster(ctx, &redshift.GetOrderableClusterArgs{
     * 			ClusterType: pulumi.StringRef("multi-node"),
     * 			PreferredNodeTypes: []string{
     * 				"dc2.large",
     * 				"ds2.xlarge",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetOrderableClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RedshiftFunctions.getOrderableCluster(GetOrderableClusterArgs.builder()
     *             .clusterType("multi-node")
     *             .preferredNodeTypes(
     *                 "dc2.large",
     *                 "ds2.xlarge")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:redshift:getOrderableCluster
     *       Arguments:
     *         clusterType: multi-node
     *         preferredNodeTypes:
     *           - dc2.large
     *           - ds2.xlarge
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOrderableCluster.
     * @return A collection of values returned by getOrderableCluster.
     */
    public suspend fun getOrderableCluster(argument: GetOrderableClusterPlainArgs): GetOrderableClusterResult =
        getOrderableClusterResultToKotlin(getOrderableClusterPlain(argument.toJava()).await())

    /**
     * @see [getOrderableCluster].
     * @param clusterType Reshift Cluster typeE.g., `multi-node` or `single-node`
     * @param clusterVersion Redshift Cluster versionE.g., `1.0`
     * @param nodeType Redshift Cluster node typeE.g., `dc2.8xlarge`
     * @param preferredNodeTypes Ordered list of preferred Redshift Cluster node types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     * @return A collection of values returned by getOrderableCluster.
     */
    public suspend fun getOrderableCluster(
        clusterType: String? = null,
        clusterVersion: String? = null,
        nodeType: String? = null,
        preferredNodeTypes: List<String>? = null,
    ): GetOrderableClusterResult {
        val argument = GetOrderableClusterPlainArgs(
            clusterType = clusterType,
            clusterVersion = clusterVersion,
            nodeType = nodeType,
            preferredNodeTypes = preferredNodeTypes,
        )
        return getOrderableClusterResultToKotlin(getOrderableClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrderableCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetOrderableClusterPlainArgs].
     * @return A collection of values returned by getOrderableCluster.
     */
    public suspend fun getOrderableCluster(argument: suspend GetOrderableClusterPlainArgsBuilder.() -> Unit): GetOrderableClusterResult {
        val builder = GetOrderableClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrderableClusterResultToKotlin(getOrderableClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing AWS Redshift Producer Data Shares.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.redshift.getProducerDataShares({
     *     producerArn: "",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.redshift.get_producer_data_shares(producer_arn="")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.RedShift.GetProducerDataShares.Invoke(new()
     *     {
     *         ProducerArn = "",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := redshift.GetProducerDataShares(ctx, &redshift.GetProducerDataSharesArgs{
     * 			ProducerArn: "",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetProducerDataSharesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getProducerDataShares(GetProducerDataSharesArgs.builder()
     *             .producerArn("")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:redshift:getProducerDataShares
     *       Arguments:
     *         producerArn:
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProducerDataShares.
     * @return A collection of values returned by getProducerDataShares.
     */
    public suspend fun getProducerDataShares(argument: GetProducerDataSharesPlainArgs): GetProducerDataSharesResult =
        getProducerDataSharesResultToKotlin(getProducerDataSharesPlain(argument.toJava()).await())

    /**
     * @see [getProducerDataShares].
     * @param dataShares An array of all data shares in the producer. See `data_shares` below.
     * @param producerArn Amazon Resource Name (ARN) of the producer namespace that returns in the list of datashares.
     * The following arguments are optional:
     * @param status Status of a datashare in the producer. Valid values are `ACTIVE`, `AUTHORIZED`, `PENDING_AUTHORIZATION`, `DEAUTHORIZED`, and `REJECTED`. Omit this argument to return all statuses.
     * @return A collection of values returned by getProducerDataShares.
     */
    public suspend fun getProducerDataShares(
        dataShares: List<GetProducerDataSharesDataShare>? = null,
        producerArn: String,
        status: String? = null,
    ): GetProducerDataSharesResult {
        val argument = GetProducerDataSharesPlainArgs(
            dataShares = dataShares,
            producerArn = producerArn,
            status = status,
        )
        return getProducerDataSharesResultToKotlin(getProducerDataSharesPlain(argument.toJava()).await())
    }

    /**
     * @see [getProducerDataShares].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetProducerDataSharesPlainArgs].
     * @return A collection of values returned by getProducerDataShares.
     */
    public suspend fun getProducerDataShares(argument: suspend GetProducerDataSharesPlainArgsBuilder.() -> Unit): GetProducerDataSharesResult {
        val builder = GetProducerDataSharesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProducerDataSharesResultToKotlin(getProducerDataSharesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the Account ID of the [AWS Redshift Service Account](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     * in a given region for the purpose of allowing Redshift to store audit data in S3.
     * > **Note:** AWS documentation [states that](https://docs&#46;aws&#46;amazon&#46;com/redshift/latest/mgmt/db-auditing&#46;html#db-auditing-bucket-permissions) a [service principal name](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services) should be used instead of an AWS account ID in any relevant IAM policy.
     * The `aws.redshift.getServiceAccount` data source has been deprecated and will be removed in a future version.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const main = aws.redshift.getServiceAccount({});
     * const bucket = new aws.s3.BucketV2("bucket", {
     *     bucket: "tf-redshift-logging-test-bucket",
     *     forceDestroy: true,
     * });
     * const allowAuditLogging = pulumi.all([main, bucket&#46;arn, main])&#46;apply(([main, arn, main1]) => aws.iam.getPolicyDocumentOutput({
     *     statements: [
     *         {
     *             sid: "Put bucket policy needed for audit logging",
     *             effect: "Allow",
     *             principals: [{
     *                 type: "AWS",
     *                 identifiers: [main&#46;arn],
     *             }],
     *             actions: ["s3:PutObject"],
     *             resources: [`${arn}/*`],
     *         },
     *         {
     *             sid: "Get bucket policy needed for audit logging",
     *             effect: "Allow",
     *             principals: [{
     *                 type: "AWS",
     *                 identifiers: [main1&#46;arn],
     *             }],
     *             actions: ["s3:GetBucketAcl"],
     *             resources: bucketAwsS3Bucket.arn,
     *         },
     *     ],
     * }));
     * const allowAuditLoggingBucketPolicy = new aws.s3.BucketPolicy("allow_audit_logging", {
     *     bucket: bucket.id,
     *     policy: allowAuditLogging.apply(allowAuditLogging => allowAuditLogging.json),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * main = aws.redshift.get_service_account()
     * bucket = aws.s3.BucketV2("bucket",
     *     bucket="tf-redshift-logging-test-bucket",
     *     force_destroy=True)
     * allow_audit_logging = bucket.arn.apply(lambda arn: aws.iam.get_policy_document_output(statements=[
     *     {
     *         "sid": "Put bucket policy needed for audit logging",
     *         "effect": "Allow",
     *         "principals": [{
     *             "type": "AWS",
     *             "identifiers": [main&#46;arn],
     *         }],
     *         "actions": ["s3:PutObject"],
     *         "resources": [f"{arn}/*"],
     *     },
     *     {
     *         "sid": "Get bucket policy needed for audit logging",
     *         "effect": "Allow",
     *         "principals": [{
     *             "type": "AWS",
     *             "identifiers": [main&#46;arn],
     *         }],
     *         "actions": ["s3:GetBucketAcl"],
     *         "resources": bucket_aws_s3_bucket["arn"],
     *     },
     * ]))
     * allow_audit_logging_bucket_policy = aws.s3.BucketPolicy("allow_audit_logging",
     *     bucket=bucket.id,
     *     policy=allow_audit_logging.json)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var main = Aws.RedShift.GetServiceAccount.Invoke();
     *     var bucket = new Aws.S3.BucketV2("bucket", new()
     *     {
     *         Bucket = "tf-redshift-logging-test-bucket",
     *         ForceDestroy = true,
     *     });
     *     var allowAuditLogging = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "Put bucket policy needed for audit logging",
     *                 Effect = "Allow",
     *                 Principals = new[]
     *                 {
     *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
     *                     {
     *                         Type = "AWS",
     *                         Identifiers = new[]
     *                         {
     *                             main.Apply(getServiceAccountResult => getServiceAccountResult.Arn),
     *                         },
     *                     },
     *                 },
     *                 Actions = new[]
     *                 {
     *                     "s3:PutObject",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     $"{bucket.Arn}/*",
     *                 },
     *             },
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "Get bucket policy needed for audit logging",
     *                 Effect = "Allow",
     *                 Principals = new[]
     *                 {
     *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
     *                     {
     *                         Type = "AWS",
     *                         Identifiers = new[]
     *                         {
     *                             main.Apply(getServiceAccountResult => getServiceAccountResult.Arn),
     *                         },
     *                     },
     *                 },
     *                 Actions = new[]
     *                 {
     *                     "s3:GetBucketAcl",
     *                 },
     *                 Resources = bucketAwsS3Bucket.Arn,
     *             },
     *         },
     *     });
     *     var allowAuditLoggingBucketPolicy = new Aws.S3.BucketPolicy("allow_audit_logging", new()
     *     {
     *         Bucket = bucket.Id,
     *         Policy = allowAuditLogging.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * main, err := redshift.GetServiceAccount(ctx, nil, nil);
     * if err != nil {
     * return err
     * }
     * bucket, err := s3.NewBucketV2(ctx, "bucket", &s3.BucketV2Args{
     * Bucket: pulumi.String("tf-redshift-logging-test-bucket"),
     * ForceDestroy: pulumi.Bool(true),
     * })
     * if err != nil {
     * return err
     * }
     * allowAuditLogging := bucket.Arn.ApplyT(func(arn string) (iam.GetPolicyDocumentResult, error) {
     * return iam.GetPolicyDocumentResult(interface{}(iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Sid: "Put bucket policy needed for audit logging",
     * Effect: "Allow",
     * Principals: []iam.GetPolicyDocumentStatementPrincipal{
     * {
     * Type: "AWS",
     * Identifiers: interface{}{
     * main.Arn,
     * },
     * },
     * },
     * Actions: []string{
     * "s3:PutObject",
     * },
     * Resources: []string{
     * fmt.Sprintf("%v/*", arn),
     * },
     * },
     * {
     * Sid: "Get bucket policy needed for audit logging",
     * Effect: "Allow",
     * Principals: []iam.GetPolicyDocumentStatementPrincipal{
     * {
     * Type: "AWS",
     * Identifiers: interface{}{
     * main.Arn,
     * },
     * },
     * },
     * Actions: []string{
     * "s3:GetBucketAcl",
     * },
     * Resources: bucketAwsS3Bucket.Arn,
     * },
     * },
     * }, nil))), nil
     * }).(iam.GetPolicyDocumentResultOutput)
     * _, err = s3.NewBucketPolicy(ctx, "allow_audit_logging", &s3.BucketPolicyArgs{
     * Bucket: bucket.ID(),
     * Policy: pulumi.String(allowAuditLogging.ApplyT(func(allowAuditLogging iam.GetPolicyDocumentResult) (*string, error) {
     * return &allowAuditLogging.Json, nil
     * }).(pulumi.StringPtrOutput)),
     * })
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetServiceAccountArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketV2Args;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = RedshiftFunctions.getServiceAccount();
     *         var bucket = new BucketV2("bucket", BucketV2Args.builder()
     *             .bucket("tf-redshift-logging-test-bucket")
     *             .forceDestroy(true)
     *             .build());
     *         final var allowAuditLogging = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("Put bucket policy needed for audit logging")
     *                     .effect("Allow")
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("AWS")
     *                         .identifiers(main.applyValue(getServiceAccountResult -> getServiceAccountResult.arn()))
     *                         .build())
     *                     .actions("s3:PutObject")
     *                     .resources(bucket.arn().applyValue(arn -> String.format("%s/*", arn)))
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("Get bucket policy needed for audit logging")
     *                     .effect("Allow")
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("AWS")
     *                         .identifiers(main.applyValue(getServiceAccountResult -> getServiceAccountResult.arn()))
     *                         .build())
     *                     .actions("s3:GetBucketAcl")
     *                     .resources(bucketAwsS3Bucket.arn())
     *                     .build())
     *             .build());
     *         var allowAuditLoggingBucketPolicy = new BucketPolicy("allowAuditLoggingBucketPolicy", BucketPolicyArgs.builder()
     *             .bucket(bucket.id())
     *             .policy(allowAuditLogging.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(allowAuditLogging -> allowAuditLogging.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   bucket:
     *     type: aws:s3:BucketV2
     *     properties:
     *       bucket: tf-redshift-logging-test-bucket
     *       forceDestroy: true
     *   allowAuditLoggingBucketPolicy:
     *     type: aws:s3:BucketPolicy
     *     name: allow_audit_logging
     *     properties:
     *       bucket: ${bucket.id}
     *       policy: ${allowAuditLogging.json}
     * variables:
     *   main:
     *     fn::invoke:
     *       Function: aws:redshift:getServiceAccount
     *       Arguments: {}
     *   allowAuditLogging:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - sid: Put bucket policy needed for audit logging
     *             effect: Allow
     *             principals:
     *               - type: AWS
     *                 identifiers:
     *                   - ${main.arn}
     *             actions:
     *               - s3:PutObject
     *             resources:
     *               - ${bucket.arn}/*
     *           - sid: Get bucket policy needed for audit logging
     *             effect: Allow
     *             principals:
     *               - type: AWS
     *                 identifiers:
     *                   - ${main.arn}
     *             actions:
     *               - s3:GetBucketAcl
     *             resources: ${bucketAwsS3Bucket.arn}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServiceAccount.
     * @return A collection of values returned by getServiceAccount.
     * */*/*/*/*/*/
     */
    public suspend fun getServiceAccount(argument: GetServiceAccountPlainArgs): GetServiceAccountResult =
        getServiceAccountResultToKotlin(getServiceAccountPlain(argument.toJava()).await())

    /**
     * @see [getServiceAccount].
     * @param region Name of the region whose AWS Redshift account ID is desired.
     * Defaults to the region from the AWS provider configuration.
     * @return A collection of values returned by getServiceAccount.
     */
    public suspend fun getServiceAccount(region: String? = null): GetServiceAccountResult {
        val argument = GetServiceAccountPlainArgs(
            region = region,
        )
        return getServiceAccountResultToKotlin(getServiceAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceAccount].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetServiceAccountPlainArgs].
     * @return A collection of values returned by getServiceAccount.
     */
    public suspend fun getServiceAccount(argument: suspend GetServiceAccountPlainArgsBuilder.() -> Unit): GetServiceAccountResult {
        val builder = GetServiceAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceAccountResultToKotlin(getServiceAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific redshift subnet group.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.redshift.getSubnetGroup({
     *     name: exampleAwsRedshiftSubnetGroup.name,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.redshift.get_subnet_group(name=example_aws_redshift_subnet_group["name"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.RedShift.GetSubnetGroup.Invoke(new()
     *     {
     *         Name = exampleAwsRedshiftSubnetGroup.Name,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := redshift.LookupSubnetGroup(ctx, &redshift.LookupSubnetGroupArgs{
     * 			Name: exampleAwsRedshiftSubnetGroup.Name,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetSubnetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getSubnetGroup(GetSubnetGroupArgs.builder()
     *             .name(exampleAwsRedshiftSubnetGroup.name())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:redshift:getSubnetGroup
     *       Arguments:
     *         name: ${exampleAwsRedshiftSubnetGroup.name}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSubnetGroup.
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: GetSubnetGroupPlainArgs): GetSubnetGroupResult =
        getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())

    /**
     * @see [getSubnetGroup].
     * @param name Name of the cluster subnet group for which information is requested.
     * @param tags Tags associated to the Subnet Group
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(name: String, tags: Map<String, String>? = null): GetSubnetGroupResult {
        val argument = GetSubnetGroupPlainArgs(
            name = name,
            tags = tags,
        )
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubnetGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetSubnetGroupPlainArgs].
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: suspend GetSubnetGroupPlainArgsBuilder.() -> Unit): GetSubnetGroupResult {
        val builder = GetSubnetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(builtArgument.toJava()).await())
    }
}
