@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.ResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Resource Policy.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.ResourcePolicy("example", {
 *     resourceArn: exampleAwsRedshiftCluster.clusterNamespaceArn,
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Effect: "Allow",
 *             Principal: {
 *                 AWS: "arn:aws:iam::12345678901:root",
 *             },
 *             Action: "redshift:CreateInboundIntegration",
 *             Resource: exampleAwsRedshiftCluster.clusterNamespaceArn,
 *             Sid: "",
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.redshift.ResourcePolicy("example",
 *     resource_arn=example_aws_redshift_cluster["clusterNamespaceArn"],
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "AWS": "arn:aws:iam::12345678901:root",
 *             },
 *             "Action": "redshift:CreateInboundIntegration",
 *             "Resource": example_aws_redshift_cluster["clusterNamespaceArn"],
 *             "Sid": "",
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.ResourcePolicy("example", new()
 *     {
 *         ResourceArn = exampleAwsRedshiftCluster.ClusterNamespaceArn,
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["AWS"] = "arn:aws:iam::12345678901:root",
 *                     },
 *                     ["Action"] = "redshift:CreateInboundIntegration",
 *                     ["Resource"] = exampleAwsRedshiftCluster.ClusterNamespaceArn,
 *                     ["Sid"] = "",
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"AWS": "arn:aws:iam::12345678901:root",
 * 					},
 * 					"Action":   "redshift:CreateInboundIntegration",
 * 					"Resource": exampleAwsRedshiftCluster.ClusterNamespaceArn,
 * 					"Sid":      "",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = redshift.NewResourcePolicy(ctx, "example", &redshift.ResourcePolicyArgs{
 * 			ResourceArn: pulumi.Any(exampleAwsRedshiftCluster.ClusterNamespaceArn),
 * 			Policy:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.ResourcePolicy;
 * import com.pulumi.aws.redshift.ResourcePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourcePolicy("example", ResourcePolicyArgs.builder()
 *             .resourceArn(exampleAwsRedshiftCluster.clusterNamespaceArn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", "arn:aws:iam::12345678901:root")
 *                         )),
 *                         jsonProperty("Action", "redshift:CreateInboundIntegration"),
 *                         jsonProperty("Resource", exampleAwsRedshiftCluster.clusterNamespaceArn()),
 *                         jsonProperty("Sid", "")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:ResourcePolicy
 *     properties:
 *       resourceArn: ${exampleAwsRedshiftCluster.clusterNamespaceArn}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Effect: Allow
 *               Principal:
 *                 AWS: arn:aws:iam::12345678901:root
 *               Action: redshift:CreateInboundIntegration
 *               Resource: ${exampleAwsRedshiftCluster.clusterNamespaceArn}
 *               Sid:
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Resource Policies using the `resource_arn`. For example:
 * ```sh
 * $ pulumi import aws:redshift/resourcePolicy:ResourcePolicy example example
 * ```
 * @property policy The content of the resource policy being updated.
 * @property resourceArn The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
 */
public data class ResourcePolicyArgs(
    public val policy: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.ResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.redshift.ResourcePolicyArgs =
        com.pulumi.aws.redshift.ResourcePolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePolicyArgs].
 */
@PulumiTagMarker
public class ResourcePolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value The content of the resource policy being updated.
     */
    @JvmName("hdufmqcaodidssjg")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
     */
    @JvmName("aatbptygljhnwkes")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The content of the resource policy being updated.
     */
    @JvmName("kbdlavknlqdaicyi")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
     */
    @JvmName("rtqcbnwukrbkuxcp")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourcePolicyArgs = ResourcePolicyArgs(
        policy = policy,
        resourceArn = resourceArn,
    )
}
