@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SnapshotCopy].
 */
@PulumiTagMarker
public class SnapshotCopyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotCopyArgs = SnapshotCopyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotCopyArgsBuilder.() -> Unit) {
        val builder = SnapshotCopyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SnapshotCopy {
        val builtJavaResource = com.pulumi.aws.redshift.SnapshotCopy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SnapshotCopy(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Redshift Snapshot Copy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.SnapshotCopy("example", {
 *     clusterIdentifier: exampleAwsRedshiftCluster.id,
 *     destinationRegion: "us-east-1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.SnapshotCopy("example",
 *     cluster_identifier=example_aws_redshift_cluster["id"],
 *     destination_region="us-east-1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.SnapshotCopy("example", new()
 *     {
 *         ClusterIdentifier = exampleAwsRedshiftCluster.Id,
 *         DestinationRegion = "us-east-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewSnapshotCopy(ctx, "example", &redshift.SnapshotCopyArgs{
 * 			ClusterIdentifier: pulumi.Any(exampleAwsRedshiftCluster.Id),
 * 			DestinationRegion: pulumi.String("us-east-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.SnapshotCopy;
 * import com.pulumi.aws.redshift.SnapshotCopyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SnapshotCopy("example", SnapshotCopyArgs.builder()
 *             .clusterIdentifier(exampleAwsRedshiftCluster.id())
 *             .destinationRegion("us-east-1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:SnapshotCopy
 *     properties:
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.id}
 *       destinationRegion: us-east-1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Snapshot Copy using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshift/snapshotCopy:SnapshotCopy example cluster-id-12345678
 * ```
 */
public class SnapshotCopy internal constructor(
    override val javaResource: com.pulumi.aws.redshift.SnapshotCopy,
) : KotlinCustomResource(javaResource, SnapshotCopyMapper) {
    /**
     * Identifier of the source cluster.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * AWS Region to copy snapshots to.
     * The following arguments are optional:
     */
    public val destinationRegion: Output<String>
        get() = javaResource.destinationRegion().applyValue({ args0 -> args0 })

    /**
     * Number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is `-1`, the manual snapshot is retained indefinitely.
     */
    public val manualSnapshotRetentionPeriod: Output<Int>
        get() = javaResource.manualSnapshotRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * Number of days to retain automated snapshots in the destination region after they are copied from the source region.
     */
    public val retentionPeriod: Output<Int>
        get() = javaResource.retentionPeriod().applyValue({ args0 -> args0 })

    /**
     * Name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
     */
    public val snapshotCopyGrantName: Output<String>?
        get() = javaResource.snapshotCopyGrantName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object SnapshotCopyMapper : ResourceMapper<SnapshotCopy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.SnapshotCopy::class == javaResource::class

    override fun map(javaResource: Resource): SnapshotCopy = SnapshotCopy(
        javaResource as
            com.pulumi.aws.redshift.SnapshotCopy,
    )
}

/**
 * @see [SnapshotCopy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SnapshotCopy].
 */
public suspend fun snapshotCopy(
    name: String,
    block: suspend SnapshotCopyResourceBuilder.() -> Unit,
): SnapshotCopy {
    val builder = SnapshotCopyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SnapshotCopy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshotCopy(name: String): SnapshotCopy {
    val builder = SnapshotCopyResourceBuilder()
    builder.name(name)
    return builder.build()
}
