@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.SnapshotCopyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Redshift Snapshot Copy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.SnapshotCopy("example", {
 *     clusterIdentifier: exampleAwsRedshiftCluster.id,
 *     destinationRegion: "us-east-1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.SnapshotCopy("example",
 *     cluster_identifier=example_aws_redshift_cluster["id"],
 *     destination_region="us-east-1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.SnapshotCopy("example", new()
 *     {
 *         ClusterIdentifier = exampleAwsRedshiftCluster.Id,
 *         DestinationRegion = "us-east-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewSnapshotCopy(ctx, "example", &redshift.SnapshotCopyArgs{
 * 			ClusterIdentifier: pulumi.Any(exampleAwsRedshiftCluster.Id),
 * 			DestinationRegion: pulumi.String("us-east-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.SnapshotCopy;
 * import com.pulumi.aws.redshift.SnapshotCopyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SnapshotCopy("example", SnapshotCopyArgs.builder()
 *             .clusterIdentifier(exampleAwsRedshiftCluster.id())
 *             .destinationRegion("us-east-1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:SnapshotCopy
 *     properties:
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.id}
 *       destinationRegion: us-east-1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Snapshot Copy using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshift/snapshotCopy:SnapshotCopy example cluster-id-12345678
 * ```
 * @property clusterIdentifier Identifier of the source cluster.
 * @property destinationRegion AWS Region to copy snapshots to.
 * The following arguments are optional:
 * @property manualSnapshotRetentionPeriod Number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is `-1`, the manual snapshot is retained indefinitely.
 * @property retentionPeriod Number of days to retain automated snapshots in the destination region after they are copied from the source region.
 * @property snapshotCopyGrantName Name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
 */
public data class SnapshotCopyArgs(
    public val clusterIdentifier: Output<String>? = null,
    public val destinationRegion: Output<String>? = null,
    public val manualSnapshotRetentionPeriod: Output<Int>? = null,
    public val retentionPeriod: Output<Int>? = null,
    public val snapshotCopyGrantName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.SnapshotCopyArgs> {
    override fun toJava(): com.pulumi.aws.redshift.SnapshotCopyArgs =
        com.pulumi.aws.redshift.SnapshotCopyArgs.builder()
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .destinationRegion(destinationRegion?.applyValue({ args0 -> args0 }))
            .manualSnapshotRetentionPeriod(manualSnapshotRetentionPeriod?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 }))
            .snapshotCopyGrantName(snapshotCopyGrantName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotCopyArgs].
 */
@PulumiTagMarker
public class SnapshotCopyArgsBuilder internal constructor() {
    private var clusterIdentifier: Output<String>? = null

    private var destinationRegion: Output<String>? = null

    private var manualSnapshotRetentionPeriod: Output<Int>? = null

    private var retentionPeriod: Output<Int>? = null

    private var snapshotCopyGrantName: Output<String>? = null

    /**
     * @param value Identifier of the source cluster.
     */
    @JvmName("qomhfcygdxuvucxf")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value AWS Region to copy snapshots to.
     * The following arguments are optional:
     */
    @JvmName("yyjqqstfniovxyxh")
    public suspend fun destinationRegion(`value`: Output<String>) {
        this.destinationRegion = value
    }

    /**
     * @param value Number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is `-1`, the manual snapshot is retained indefinitely.
     */
    @JvmName("hkdcbxktyylmoqrw")
    public suspend fun manualSnapshotRetentionPeriod(`value`: Output<Int>) {
        this.manualSnapshotRetentionPeriod = value
    }

    /**
     * @param value Number of days to retain automated snapshots in the destination region after they are copied from the source region.
     */
    @JvmName("tdrferagpttsswax")
    public suspend fun retentionPeriod(`value`: Output<Int>) {
        this.retentionPeriod = value
    }

    /**
     * @param value Name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
     */
    @JvmName("viohcnyovvphplqp")
    public suspend fun snapshotCopyGrantName(`value`: Output<String>) {
        this.snapshotCopyGrantName = value
    }

    /**
     * @param value Identifier of the source cluster.
     */
    @JvmName("hxtuelhphwydtcop")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value AWS Region to copy snapshots to.
     * The following arguments are optional:
     */
    @JvmName("fiephigrcttopggp")
    public suspend fun destinationRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationRegion = mapped
    }

    /**
     * @param value Number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is `-1`, the manual snapshot is retained indefinitely.
     */
    @JvmName("acogsnmktgjjvqoa")
    public suspend fun manualSnapshotRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manualSnapshotRetentionPeriod = mapped
    }

    /**
     * @param value Number of days to retain automated snapshots in the destination region after they are copied from the source region.
     */
    @JvmName("nvbfbshsxfmsixnp")
    public suspend fun retentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    /**
     * @param value Name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
     */
    @JvmName("lnrklsdifumtmidd")
    public suspend fun snapshotCopyGrantName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotCopyGrantName = mapped
    }

    internal fun build(): SnapshotCopyArgs = SnapshotCopyArgs(
        clusterIdentifier = clusterIdentifier,
        destinationRegion = destinationRegion,
        manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod,
        retentionPeriod = retentionPeriod,
        snapshotCopyGrantName = snapshotCopyGrantName,
    )
}
