@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SnapshotCopyGrant].
 */
@PulumiTagMarker
public class SnapshotCopyGrantResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotCopyGrantArgs = SnapshotCopyGrantArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotCopyGrantArgsBuilder.() -> Unit) {
        val builder = SnapshotCopyGrantArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SnapshotCopyGrant {
        val builtJavaResource = com.pulumi.aws.redshift.SnapshotCopyGrant(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SnapshotCopyGrant(builtJavaResource)
    }
}

/**
 * Creates a snapshot copy grant that allows AWS Redshift to encrypt copied snapshots with a customer master key from AWS KMS in a destination region.
 * Note that the grant must exist in the destination region, and not in the region of the cluster.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.redshift.SnapshotCopyGrant("test", {snapshotCopyGrantName: "my-grant"});
 * const testCluster = new aws.redshift.Cluster("test", {snapshotCopy: {
 *     destinationRegion: "us-east-2",
 *     grantName: test.snapshotCopyGrantName,
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.redshift.SnapshotCopyGrant("test", snapshot_copy_grant_name="my-grant")
 * test_cluster = aws.redshift.Cluster("test", snapshot_copy={
 *     "destination_region": "us-east-2",
 *     "grant_name": test.snapshot_copy_grant_name,
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.RedShift.SnapshotCopyGrant("test", new()
 *     {
 *         SnapshotCopyGrantName = "my-grant",
 *     });
 *     var testCluster = new Aws.RedShift.Cluster("test", new()
 *     {
 *         SnapshotCopy = new Aws.RedShift.Inputs.ClusterSnapshotCopyArgs
 *         {
 *             DestinationRegion = "us-east-2",
 *             GrantName = test.SnapshotCopyGrantName,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := redshift.NewSnapshotCopyGrant(ctx, "test", &redshift.SnapshotCopyGrantArgs{
 * 			SnapshotCopyGrantName: pulumi.String("my-grant"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = redshift.NewCluster(ctx, "test", &redshift.ClusterArgs{
 * 			SnapshotCopy: &redshift.ClusterSnapshotCopyArgs{
 * 				DestinationRegion: pulumi.String("us-east-2"),
 * 				GrantName:         test.SnapshotCopyGrantName,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.SnapshotCopyGrant;
 * import com.pulumi.aws.redshift.SnapshotCopyGrantArgs;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import com.pulumi.aws.redshift.inputs.ClusterSnapshotCopyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new SnapshotCopyGrant("test", SnapshotCopyGrantArgs.builder()
 *             .snapshotCopyGrantName("my-grant")
 *             .build());
 *         var testCluster = new Cluster("testCluster", ClusterArgs.builder()
 *             .snapshotCopy(ClusterSnapshotCopyArgs.builder()
 *                 .destinationRegion("us-east-2")
 *                 .grantName(test.snapshotCopyGrantName())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:redshift:SnapshotCopyGrant
 *     properties:
 *       snapshotCopyGrantName: my-grant
 *   testCluster:
 *     type: aws:redshift:Cluster
 *     name: test
 *     properties:
 *       snapshotCopy:
 *         destinationRegion: us-east-2
 *         grantName: ${test.snapshotCopyGrantName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Snapshot Copy Grants by name. For example:
 * ```sh
 * $ pulumi import aws:redshift/snapshotCopyGrant:SnapshotCopyGrant test my-grant
 * ```
 */
public class SnapshotCopyGrant internal constructor(
    override val javaResource: com.pulumi.aws.redshift.SnapshotCopyGrant,
) : KotlinCustomResource(javaResource, SnapshotCopyGrantMapper) {
    /**
     * Amazon Resource Name (ARN) of snapshot copy grant
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The unique identifier for the customer master key (CMK) that the grant applies to. Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To specify a CMK in a different AWS account, you must use the key ARN. If not specified, the default key is used.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * A friendly name for identifying the grant.
     */
    public val snapshotCopyGrantName: Output<String>
        get() = javaResource.snapshotCopyGrantName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SnapshotCopyGrantMapper : ResourceMapper<SnapshotCopyGrant> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.SnapshotCopyGrant::class == javaResource::class

    override fun map(javaResource: Resource): SnapshotCopyGrant = SnapshotCopyGrant(
        javaResource as
            com.pulumi.aws.redshift.SnapshotCopyGrant,
    )
}

/**
 * @see [SnapshotCopyGrant].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SnapshotCopyGrant].
 */
public suspend fun snapshotCopyGrant(
    name: String,
    block: suspend SnapshotCopyGrantResourceBuilder.() -> Unit,
): SnapshotCopyGrant {
    val builder = SnapshotCopyGrantResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SnapshotCopyGrant].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshotCopyGrant(name: String): SnapshotCopyGrant {
    val builder = SnapshotCopyGrantResourceBuilder()
    builder.name(name)
    return builder.build()
}
