@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.SnapshotCopyGrantArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a snapshot copy grant that allows AWS Redshift to encrypt copied snapshots with a customer master key from AWS KMS in a destination region.
 * Note that the grant must exist in the destination region, and not in the region of the cluster.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.redshift.SnapshotCopyGrant("test", {snapshotCopyGrantName: "my-grant"});
 * const testCluster = new aws.redshift.Cluster("test", {snapshotCopy: {
 *     destinationRegion: "us-east-2",
 *     grantName: test.snapshotCopyGrantName,
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.redshift.SnapshotCopyGrant("test", snapshot_copy_grant_name="my-grant")
 * test_cluster = aws.redshift.Cluster("test", snapshot_copy={
 *     "destination_region": "us-east-2",
 *     "grant_name": test.snapshot_copy_grant_name,
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.RedShift.SnapshotCopyGrant("test", new()
 *     {
 *         SnapshotCopyGrantName = "my-grant",
 *     });
 *     var testCluster = new Aws.RedShift.Cluster("test", new()
 *     {
 *         SnapshotCopy = new Aws.RedShift.Inputs.ClusterSnapshotCopyArgs
 *         {
 *             DestinationRegion = "us-east-2",
 *             GrantName = test.SnapshotCopyGrantName,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := redshift.NewSnapshotCopyGrant(ctx, "test", &redshift.SnapshotCopyGrantArgs{
 * 			SnapshotCopyGrantName: pulumi.String("my-grant"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = redshift.NewCluster(ctx, "test", &redshift.ClusterArgs{
 * 			SnapshotCopy: &redshift.ClusterSnapshotCopyArgs{
 * 				DestinationRegion: pulumi.String("us-east-2"),
 * 				GrantName:         test.SnapshotCopyGrantName,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.SnapshotCopyGrant;
 * import com.pulumi.aws.redshift.SnapshotCopyGrantArgs;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import com.pulumi.aws.redshift.inputs.ClusterSnapshotCopyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new SnapshotCopyGrant("test", SnapshotCopyGrantArgs.builder()
 *             .snapshotCopyGrantName("my-grant")
 *             .build());
 *         var testCluster = new Cluster("testCluster", ClusterArgs.builder()
 *             .snapshotCopy(ClusterSnapshotCopyArgs.builder()
 *                 .destinationRegion("us-east-2")
 *                 .grantName(test.snapshotCopyGrantName())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:redshift:SnapshotCopyGrant
 *     properties:
 *       snapshotCopyGrantName: my-grant
 *   testCluster:
 *     type: aws:redshift:Cluster
 *     name: test
 *     properties:
 *       snapshotCopy:
 *         destinationRegion: us-east-2
 *         grantName: ${test.snapshotCopyGrantName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Snapshot Copy Grants by name. For example:
 * ```sh
 * $ pulumi import aws:redshift/snapshotCopyGrant:SnapshotCopyGrant test my-grant
 * ```
 * @property kmsKeyId The unique identifier for the customer master key (CMK) that the grant applies to. Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To specify a CMK in a different AWS account, you must use the key ARN. If not specified, the default key is used.
 * @property snapshotCopyGrantName A friendly name for identifying the grant.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SnapshotCopyGrantArgs(
    public val kmsKeyId: Output<String>? = null,
    public val snapshotCopyGrantName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.SnapshotCopyGrantArgs> {
    override fun toJava(): com.pulumi.aws.redshift.SnapshotCopyGrantArgs =
        com.pulumi.aws.redshift.SnapshotCopyGrantArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .snapshotCopyGrantName(snapshotCopyGrantName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SnapshotCopyGrantArgs].
 */
@PulumiTagMarker
public class SnapshotCopyGrantArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var snapshotCopyGrantName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The unique identifier for the customer master key (CMK) that the grant applies to. Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To specify a CMK in a different AWS account, you must use the key ARN. If not specified, the default key is used.
     */
    @JvmName("bxacamlwfbmxqoxe")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value A friendly name for identifying the grant.
     */
    @JvmName("lfdtismgxrtfkeil")
    public suspend fun snapshotCopyGrantName(`value`: Output<String>) {
        this.snapshotCopyGrantName = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("winfnhshefpymgtq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The unique identifier for the customer master key (CMK) that the grant applies to. Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To specify a CMK in a different AWS account, you must use the key ARN. If not specified, the default key is used.
     */
    @JvmName("bjxxnioggctrubqe")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value A friendly name for identifying the grant.
     */
    @JvmName("qyrhakmijrvtrjjj")
    public suspend fun snapshotCopyGrantName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotCopyGrantName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hddmnxjjsswjbwug")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aqrnpcbimhdgqgab")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SnapshotCopyGrantArgs = SnapshotCopyGrantArgs(
        kmsKeyId = kmsKeyId,
        snapshotCopyGrantName = snapshotCopyGrantName,
        tags = tags,
    )
}
