@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [SnapshotSchedule].
 */
@PulumiTagMarker
public class SnapshotScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotScheduleArgs = SnapshotScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotScheduleArgsBuilder.() -> Unit) {
        val builder = SnapshotScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SnapshotSchedule {
        val builtJavaResource = com.pulumi.aws.redshift.SnapshotSchedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SnapshotSchedule(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.redshift.SnapshotSchedule("default", {
 *     identifier: "tf-redshift-snapshot-schedule",
 *     definitions: ["rate(12 hours)"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.redshift.SnapshotSchedule("default",
 *     identifier="tf-redshift-snapshot-schedule",
 *     definitions=["rate(12 hours)"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.RedShift.SnapshotSchedule("default", new()
 *     {
 *         Identifier = "tf-redshift-snapshot-schedule",
 *         Definitions = new[]
 *         {
 *             "rate(12 hours)",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewSnapshotSchedule(ctx, "default", &redshift.SnapshotScheduleArgs{
 * 			Identifier: pulumi.String("tf-redshift-snapshot-schedule"),
 * 			Definitions: pulumi.StringArray{
 * 				pulumi.String("rate(12 hours)"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.SnapshotSchedule;
 * import com.pulumi.aws.redshift.SnapshotScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SnapshotSchedule("default", SnapshotScheduleArgs.builder()
 *             .identifier("tf-redshift-snapshot-schedule")
 *             .definitions("rate(12 hours)")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:redshift:SnapshotSchedule
 *     properties:
 *       identifier: tf-redshift-snapshot-schedule
 *       definitions:
 *         - rate(12 hours)
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift Snapshot Schedule using the `identifier`. For example:
 * ```sh
 * $ pulumi import aws:redshift/snapshotSchedule:SnapshotSchedule default tf-redshift-snapshot-schedule
 * ```
 */
public class SnapshotSchedule internal constructor(
    override val javaResource: com.pulumi.aws.redshift.SnapshotSchedule,
) : KotlinCustomResource(javaResource, SnapshotScheduleMapper) {
    /**
     * Amazon Resource Name (ARN) of the Redshift Snapshot Schedule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The definition of the snapshot schedule. The definition is made up of schedule expressions, for example `cron(30 12 *)` or `rate(12 hours)`.
     */
    public val definitions: Output<List<String>>
        get() = javaResource.definitions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The description of the snapshot schedule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to destroy all associated clusters with this snapshot schedule on deletion. Must be enabled and applied before attempting deletion.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The snapshot schedule identifier. If omitted, this provider will assign a random, unique identifier.
     */
    public val identifier: Output<String>
        get() = javaResource.identifier().applyValue({ args0 -> args0 })

    /**
     * Creates a unique
     * identifier beginning with the specified prefix. Conflicts with `identifier`.
     */
    public val identifierPrefix: Output<String>
        get() = javaResource.identifierPrefix().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SnapshotScheduleMapper : ResourceMapper<SnapshotSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.SnapshotSchedule::class == javaResource::class

    override fun map(javaResource: Resource): SnapshotSchedule = SnapshotSchedule(
        javaResource as
            com.pulumi.aws.redshift.SnapshotSchedule,
    )
}

/**
 * @see [SnapshotSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SnapshotSchedule].
 */
public suspend fun snapshotSchedule(
    name: String,
    block: suspend SnapshotScheduleResourceBuilder.() -> Unit,
): SnapshotSchedule {
    val builder = SnapshotScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SnapshotSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshotSchedule(name: String): SnapshotSchedule {
    val builder = SnapshotScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
