@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [SubnetGroup].
 */
@PulumiTagMarker
public class SubnetGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubnetGroupArgs = SubnetGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubnetGroupArgsBuilder.() -> Unit) {
        val builder = SubnetGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SubnetGroup {
        val builtJavaResource = com.pulumi.aws.redshift.SubnetGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SubnetGroup(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.ec2.Vpc("foo", {cidrBlock: "10.1.0.0/16"});
 * const fooSubnet = new aws.ec2.Subnet("foo", {
 *     cidrBlock: "10.1.1.0/24",
 *     availabilityZone: "us-west-2a",
 *     vpcId: foo.id,
 *     tags: {
 *         Name: "tf-dbsubnet-test-1",
 *     },
 * });
 * const bar = new aws.ec2.Subnet("bar", {
 *     cidrBlock: "10.1.2.0/24",
 *     availabilityZone: "us-west-2b",
 *     vpcId: foo.id,
 *     tags: {
 *         Name: "tf-dbsubnet-test-2",
 *     },
 * });
 * const fooSubnetGroup = new aws.redshift.SubnetGroup("foo", {
 *     name: "foo",
 *     subnetIds: [
 *         fooSubnet.id,
 *         bar.id,
 *     ],
 *     tags: {
 *         environment: "Production",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.ec2.Vpc("foo", cidr_block="10.1.0.0/16")
 * foo_subnet = aws.ec2.Subnet("foo",
 *     cidr_block="10.1.1.0/24",
 *     availability_zone="us-west-2a",
 *     vpc_id=foo.id,
 *     tags={
 *         "Name": "tf-dbsubnet-test-1",
 *     })
 * bar = aws.ec2.Subnet("bar",
 *     cidr_block="10.1.2.0/24",
 *     availability_zone="us-west-2b",
 *     vpc_id=foo.id,
 *     tags={
 *         "Name": "tf-dbsubnet-test-2",
 *     })
 * foo_subnet_group = aws.redshift.SubnetGroup("foo",
 *     name="foo",
 *     subnet_ids=[
 *         foo_subnet.id,
 *         bar.id,
 *     ],
 *     tags={
 *         "environment": "Production",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Ec2.Vpc("foo", new()
 *     {
 *         CidrBlock = "10.1.0.0/16",
 *     });
 *     var fooSubnet = new Aws.Ec2.Subnet("foo", new()
 *     {
 *         CidrBlock = "10.1.1.0/24",
 *         AvailabilityZone = "us-west-2a",
 *         VpcId = foo.Id,
 *         Tags =
 *         {
 *             { "Name", "tf-dbsubnet-test-1" },
 *         },
 *     });
 *     var bar = new Aws.Ec2.Subnet("bar", new()
 *     {
 *         CidrBlock = "10.1.2.0/24",
 *         AvailabilityZone = "us-west-2b",
 *         VpcId = foo.Id,
 *         Tags =
 *         {
 *             { "Name", "tf-dbsubnet-test-2" },
 *         },
 *     });
 *     var fooSubnetGroup = new Aws.RedShift.SubnetGroup("foo", new()
 *     {
 *         Name = "foo",
 *         SubnetIds = new[]
 *         {
 *             fooSubnet.Id,
 *             bar.Id,
 *         },
 *         Tags =
 *         {
 *             { "environment", "Production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := ec2.NewVpc(ctx, "foo", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.1.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooSubnet, err := ec2.NewSubnet(ctx, "foo", &ec2.SubnetArgs{
 * 			CidrBlock:        pulumi.String("10.1.1.0/24"),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			VpcId:            foo.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-dbsubnet-test-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bar, err := ec2.NewSubnet(ctx, "bar", &ec2.SubnetArgs{
 * 			CidrBlock:        pulumi.String("10.1.2.0/24"),
 * 			AvailabilityZone: pulumi.String("us-west-2b"),
 * 			VpcId:            foo.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-dbsubnet-test-2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = redshift.NewSubnetGroup(ctx, "foo", &redshift.SubnetGroupArgs{
 * 			Name: pulumi.String("foo"),
 * 			SubnetIds: pulumi.StringArray{
 * 				fooSubnet.ID(),
 * 				bar.ID(),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"environment": pulumi.String("Production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.redshift.SubnetGroup;
 * import com.pulumi.aws.redshift.SubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Vpc("foo", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var fooSubnet = new Subnet("fooSubnet", SubnetArgs.builder()
 *             .cidrBlock("10.1.1.0/24")
 *             .availabilityZone("us-west-2a")
 *             .vpcId(foo.id())
 *             .tags(Map.of("Name", "tf-dbsubnet-test-1"))
 *             .build());
 *         var bar = new Subnet("bar", SubnetArgs.builder()
 *             .cidrBlock("10.1.2.0/24")
 *             .availabilityZone("us-west-2b")
 *             .vpcId(foo.id())
 *             .tags(Map.of("Name", "tf-dbsubnet-test-2"))
 *             .build());
 *         var fooSubnetGroup = new SubnetGroup("fooSubnetGroup", SubnetGroupArgs.builder()
 *             .name("foo")
 *             .subnetIds(
 *                 fooSubnet.id(),
 *                 bar.id())
 *             .tags(Map.of("environment", "Production"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.1.0.0/16
 *   fooSubnet:
 *     type: aws:ec2:Subnet
 *     name: foo
 *     properties:
 *       cidrBlock: 10.1.1.0/24
 *       availabilityZone: us-west-2a
 *       vpcId: ${foo.id}
 *       tags:
 *         Name: tf-dbsubnet-test-1
 *   bar:
 *     type: aws:ec2:Subnet
 *     properties:
 *       cidrBlock: 10.1.2.0/24
 *       availabilityZone: us-west-2b
 *       vpcId: ${foo.id}
 *       tags:
 *         Name: tf-dbsubnet-test-2
 *   fooSubnetGroup:
 *     type: aws:redshift:SubnetGroup
 *     name: foo
 *     properties:
 *       name: foo
 *       subnetIds:
 *         - ${fooSubnet.id}
 *         - ${bar.id}
 *       tags:
 *         environment: Production
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift subnet groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:redshift/subnetGroup:SubnetGroup testgroup1 test-cluster-subnet-group
 * ```
 */
public class SubnetGroup internal constructor(
    override val javaResource: com.pulumi.aws.redshift.SubnetGroup,
) : KotlinCustomResource(javaResource, SubnetGroupMapper) {
    /**
     * Amazon Resource Name (ARN) of the Redshift Subnet group name
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the Redshift Subnet group. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The name of the Redshift Subnet group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An array of VPC subnet IDs.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SubnetGroupMapper : ResourceMapper<SubnetGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.SubnetGroup::class == javaResource::class

    override fun map(javaResource: Resource): SubnetGroup = SubnetGroup(
        javaResource as
            com.pulumi.aws.redshift.SubnetGroup,
    )
}

/**
 * @see [SubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SubnetGroup].
 */
public suspend fun subnetGroup(name: String, block: suspend SubnetGroupResourceBuilder.() -> Unit): SubnetGroup {
    val builder = SubnetGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subnetGroup(name: String): SubnetGroup {
    val builder = SubnetGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
