@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.SubnetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.ec2.Vpc("foo", {cidrBlock: "10.1.0.0/16"});
 * const fooSubnet = new aws.ec2.Subnet("foo", {
 *     cidrBlock: "10.1.1.0/24",
 *     availabilityZone: "us-west-2a",
 *     vpcId: foo.id,
 *     tags: {
 *         Name: "tf-dbsubnet-test-1",
 *     },
 * });
 * const bar = new aws.ec2.Subnet("bar", {
 *     cidrBlock: "10.1.2.0/24",
 *     availabilityZone: "us-west-2b",
 *     vpcId: foo.id,
 *     tags: {
 *         Name: "tf-dbsubnet-test-2",
 *     },
 * });
 * const fooSubnetGroup = new aws.redshift.SubnetGroup("foo", {
 *     name: "foo",
 *     subnetIds: [
 *         fooSubnet.id,
 *         bar.id,
 *     ],
 *     tags: {
 *         environment: "Production",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.ec2.Vpc("foo", cidr_block="10.1.0.0/16")
 * foo_subnet = aws.ec2.Subnet("foo",
 *     cidr_block="10.1.1.0/24",
 *     availability_zone="us-west-2a",
 *     vpc_id=foo.id,
 *     tags={
 *         "Name": "tf-dbsubnet-test-1",
 *     })
 * bar = aws.ec2.Subnet("bar",
 *     cidr_block="10.1.2.0/24",
 *     availability_zone="us-west-2b",
 *     vpc_id=foo.id,
 *     tags={
 *         "Name": "tf-dbsubnet-test-2",
 *     })
 * foo_subnet_group = aws.redshift.SubnetGroup("foo",
 *     name="foo",
 *     subnet_ids=[
 *         foo_subnet.id,
 *         bar.id,
 *     ],
 *     tags={
 *         "environment": "Production",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Ec2.Vpc("foo", new()
 *     {
 *         CidrBlock = "10.1.0.0/16",
 *     });
 *     var fooSubnet = new Aws.Ec2.Subnet("foo", new()
 *     {
 *         CidrBlock = "10.1.1.0/24",
 *         AvailabilityZone = "us-west-2a",
 *         VpcId = foo.Id,
 *         Tags =
 *         {
 *             { "Name", "tf-dbsubnet-test-1" },
 *         },
 *     });
 *     var bar = new Aws.Ec2.Subnet("bar", new()
 *     {
 *         CidrBlock = "10.1.2.0/24",
 *         AvailabilityZone = "us-west-2b",
 *         VpcId = foo.Id,
 *         Tags =
 *         {
 *             { "Name", "tf-dbsubnet-test-2" },
 *         },
 *     });
 *     var fooSubnetGroup = new Aws.RedShift.SubnetGroup("foo", new()
 *     {
 *         Name = "foo",
 *         SubnetIds = new[]
 *         {
 *             fooSubnet.Id,
 *             bar.Id,
 *         },
 *         Tags =
 *         {
 *             { "environment", "Production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := ec2.NewVpc(ctx, "foo", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.1.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooSubnet, err := ec2.NewSubnet(ctx, "foo", &ec2.SubnetArgs{
 * 			CidrBlock:        pulumi.String("10.1.1.0/24"),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			VpcId:            foo.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-dbsubnet-test-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bar, err := ec2.NewSubnet(ctx, "bar", &ec2.SubnetArgs{
 * 			CidrBlock:        pulumi.String("10.1.2.0/24"),
 * 			AvailabilityZone: pulumi.String("us-west-2b"),
 * 			VpcId:            foo.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-dbsubnet-test-2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = redshift.NewSubnetGroup(ctx, "foo", &redshift.SubnetGroupArgs{
 * 			Name: pulumi.String("foo"),
 * 			SubnetIds: pulumi.StringArray{
 * 				fooSubnet.ID(),
 * 				bar.ID(),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"environment": pulumi.String("Production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.redshift.SubnetGroup;
 * import com.pulumi.aws.redshift.SubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Vpc("foo", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var fooSubnet = new Subnet("fooSubnet", SubnetArgs.builder()
 *             .cidrBlock("10.1.1.0/24")
 *             .availabilityZone("us-west-2a")
 *             .vpcId(foo.id())
 *             .tags(Map.of("Name", "tf-dbsubnet-test-1"))
 *             .build());
 *         var bar = new Subnet("bar", SubnetArgs.builder()
 *             .cidrBlock("10.1.2.0/24")
 *             .availabilityZone("us-west-2b")
 *             .vpcId(foo.id())
 *             .tags(Map.of("Name", "tf-dbsubnet-test-2"))
 *             .build());
 *         var fooSubnetGroup = new SubnetGroup("fooSubnetGroup", SubnetGroupArgs.builder()
 *             .name("foo")
 *             .subnetIds(
 *                 fooSubnet.id(),
 *                 bar.id())
 *             .tags(Map.of("environment", "Production"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.1.0.0/16
 *   fooSubnet:
 *     type: aws:ec2:Subnet
 *     name: foo
 *     properties:
 *       cidrBlock: 10.1.1.0/24
 *       availabilityZone: us-west-2a
 *       vpcId: ${foo.id}
 *       tags:
 *         Name: tf-dbsubnet-test-1
 *   bar:
 *     type: aws:ec2:Subnet
 *     properties:
 *       cidrBlock: 10.1.2.0/24
 *       availabilityZone: us-west-2b
 *       vpcId: ${foo.id}
 *       tags:
 *         Name: tf-dbsubnet-test-2
 *   fooSubnetGroup:
 *     type: aws:redshift:SubnetGroup
 *     name: foo
 *     properties:
 *       name: foo
 *       subnetIds:
 *         - ${fooSubnet.id}
 *         - ${bar.id}
 *       tags:
 *         environment: Production
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift subnet groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:redshift/subnetGroup:SubnetGroup testgroup1 test-cluster-subnet-group
 * ```
 * @property description The description of the Redshift Subnet group. Defaults to "Managed by Pulumi".
 * @property name The name of the Redshift Subnet group.
 * @property subnetIds An array of VPC subnet IDs.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SubnetGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.SubnetGroupArgs> {
    override fun toJava(): com.pulumi.aws.redshift.SubnetGroupArgs =
        com.pulumi.aws.redshift.SubnetGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SubnetGroupArgs].
 */
@PulumiTagMarker
public class SubnetGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the Redshift Subnet group. Defaults to "Managed by Pulumi".
     */
    @JvmName("pvaomhpnwtwhfoto")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the Redshift Subnet group.
     */
    @JvmName("iiiwwctfppdpkbqm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An array of VPC subnet IDs.
     */
    @JvmName("vngwvxygnhjrigbp")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("khdbsyjccsumodej")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values An array of VPC subnet IDs.
     */
    @JvmName("qmhttgkwqdylhhwx")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ighcfguonlgddfeo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the Redshift Subnet group. Defaults to "Managed by Pulumi".
     */
    @JvmName("xgvmsqaflbkqhqxu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the Redshift Subnet group.
     */
    @JvmName("nwedddjufubfspjb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An array of VPC subnet IDs.
     */
    @JvmName("minqjipwemhumdog")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values An array of VPC subnet IDs.
     */
    @JvmName("oibapcxaksloyyab")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xmqiapyupntpojpq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("noivpmwfqasrymny")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SubnetGroupArgs = SubnetGroupArgs(
        description = description,
        name = name,
        subnetIds = subnetIds,
        tags = tags,
    )
}
