@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [UsageLimit].
 */
@PulumiTagMarker
public class UsageLimitResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UsageLimitArgs = UsageLimitArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UsageLimitArgsBuilder.() -> Unit) {
        val builder = UsageLimitArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UsageLimit {
        val builtJavaResource = com.pulumi.aws.redshift.UsageLimit(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UsageLimit(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift Usage Limit.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshift.UsageLimit("example", {
 *     clusterIdentifier: exampleAwsRedshiftCluster.id,
 *     featureType: "concurrency-scaling",
 *     limitType: "time",
 *     amount: 60,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshift.UsageLimit("example",
 *     cluster_identifier=example_aws_redshift_cluster["id"],
 *     feature_type="concurrency-scaling",
 *     limit_type="time",
 *     amount=60)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedShift.UsageLimit("example", new()
 *     {
 *         ClusterIdentifier = exampleAwsRedshiftCluster.Id,
 *         FeatureType = "concurrency-scaling",
 *         LimitType = "time",
 *         Amount = 60,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redshift.NewUsageLimit(ctx, "example", &redshift.UsageLimitArgs{
 * 			ClusterIdentifier: pulumi.Any(exampleAwsRedshiftCluster.Id),
 * 			FeatureType:       pulumi.String("concurrency-scaling"),
 * 			LimitType:         pulumi.String("time"),
 * 			Amount:            pulumi.Int(60),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.UsageLimit;
 * import com.pulumi.aws.redshift.UsageLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UsageLimit("example", UsageLimitArgs.builder()
 *             .clusterIdentifier(exampleAwsRedshiftCluster.id())
 *             .featureType("concurrency-scaling")
 *             .limitType("time")
 *             .amount(60)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshift:UsageLimit
 *     properties:
 *       clusterIdentifier: ${exampleAwsRedshiftCluster.id}
 *       featureType: concurrency-scaling
 *       limitType: time
 *       amount: 60
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Redshift usage limits using the `id`. For example:
 * ```sh
 * $ pulumi import aws:redshift/usageLimit:UsageLimit example example-id
 * ```
 */
public class UsageLimit internal constructor(
    override val javaResource: com.pulumi.aws.redshift.UsageLimit,
) : KotlinCustomResource(javaResource, UsageLimitMapper) {
    /**
     * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number.
     */
    public val amount: Output<Int>
        get() = javaResource.amount().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the Redshift Usage Limit.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The action that Amazon Redshift takes when the limit is reached. The default is `log`. Valid values are `log`, `emit-metric`, and `disable`.
     */
    public val breachAction: Output<String>?
        get() = javaResource.breachAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identifier of the cluster that you want to limit usage.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The Amazon Redshift feature that you want to limit. Valid values are `spectrum`, `concurrency-scaling`, and `cross-region-datasharing`.
     */
    public val featureType: Output<String>
        get() = javaResource.featureType().applyValue({ args0 -> args0 })

    /**
     * The type of limit. Depending on the feature type, this can be based on a time duration or data size. If FeatureType is `spectrum`, then LimitType must be `data-scanned`. If FeatureType is `concurrency-scaling`, then LimitType must be `time`. If FeatureType is `cross-region-datasharing`, then LimitType must be `data-scanned`. Valid values are `data-scanned`, and `time`.
     */
    public val limitType: Output<String>
        get() = javaResource.limitType().applyValue({ args0 -> args0 })

    /**
     * The time period that the amount applies to. A weekly period begins on Sunday. The default is `monthly`. Valid values are `daily`, `weekly`, and `monthly`.
     */
    public val period: Output<String>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object UsageLimitMapper : ResourceMapper<UsageLimit> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.UsageLimit::class == javaResource::class

    override fun map(javaResource: Resource): UsageLimit = UsageLimit(
        javaResource as
            com.pulumi.aws.redshift.UsageLimit,
    )
}

/**
 * @see [UsageLimit].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UsageLimit].
 */
public suspend fun usageLimit(name: String, block: suspend UsageLimitResourceBuilder.() -> Unit): UsageLimit {
    val builder = UsageLimitResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UsageLimit].
 * @param name The _unique_ name of the resulting resource.
 */
public fun usageLimit(name: String): UsageLimit {
    val builder = UsageLimitResourceBuilder()
    builder.name(name)
    return builder.build()
}
