@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.inputs

import com.pulumi.aws.redshift.inputs.GetClusterCredentialsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusterCredentials.
 * @property autoCreate Create a database user with the name specified for the user named in `db_user` if one does not exist.
 * @property clusterIdentifier Unique identifier of the cluster that contains the database for which your are requesting credentials.
 * @property dbGroups List of the names of existing database groups that the user named in `db_user` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to `PUBLIC`.
 * @property dbName Name of a database that DbUser is authorized to log on to. If `db_name` is not specified, `db_user` can log on to any existing database.
 * @property dbUser Name of a database user. If a user name matching `db_user` exists in the database, the temporary user credentials have the same permissions as the  existing user. If `db_user` doesn't exist in the database and `auto_create` is `True`, a new user is created using the value for `db_user` with `PUBLIC` permissions.  If a database user matching the value for `db_user` doesn't exist and `not` is `False`, then the command succeeds but the connection attempt will fail because the user doesn't exist in the database.
 * @property durationSeconds The number of seconds until the returned temporary password expires. Valid values are between `900` and `3600`. Default value is `900`.
 */
public data class GetClusterCredentialsPlainArgs(
    public val autoCreate: Boolean? = null,
    public val clusterIdentifier: String,
    public val dbGroups: List<String>? = null,
    public val dbName: String? = null,
    public val dbUser: String,
    public val durationSeconds: Int? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.inputs.GetClusterCredentialsPlainArgs> {
    override fun toJava(): com.pulumi.aws.redshift.inputs.GetClusterCredentialsPlainArgs =
        com.pulumi.aws.redshift.inputs.GetClusterCredentialsPlainArgs.builder()
            .autoCreate(autoCreate?.let({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier.let({ args0 -> args0 }))
            .dbGroups(dbGroups?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .dbName(dbName?.let({ args0 -> args0 }))
            .dbUser(dbUser.let({ args0 -> args0 }))
            .durationSeconds(durationSeconds?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterCredentialsPlainArgs].
 */
@PulumiTagMarker
public class GetClusterCredentialsPlainArgsBuilder internal constructor() {
    private var autoCreate: Boolean? = null

    private var clusterIdentifier: String? = null

    private var dbGroups: List<String>? = null

    private var dbName: String? = null

    private var dbUser: String? = null

    private var durationSeconds: Int? = null

    /**
     * @param value Create a database user with the name specified for the user named in `db_user` if one does not exist.
     */
    @JvmName("ilratjjboaaieuye")
    public suspend fun autoCreate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.autoCreate = mapped
    }

    /**
     * @param value Unique identifier of the cluster that contains the database for which your are requesting credentials.
     */
    @JvmName("hispovvjmnkkafdu")
    public suspend fun clusterIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value List of the names of existing database groups that the user named in `db_user` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to `PUBLIC`.
     */
    @JvmName("qduumcuitfhpeweo")
    public suspend fun dbGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbGroups = mapped
    }

    /**
     * @param values List of the names of existing database groups that the user named in `db_user` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to `PUBLIC`.
     */
    @JvmName("pmcbyipbexwjbkjo")
    public suspend fun dbGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbGroups = mapped
    }

    /**
     * @param value Name of a database that DbUser is authorized to log on to. If `db_name` is not specified, `db_user` can log on to any existing database.
     */
    @JvmName("tibbllriqopanfph")
    public suspend fun dbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbName = mapped
    }

    /**
     * @param value Name of a database user. If a user name matching `db_user` exists in the database, the temporary user credentials have the same permissions as the  existing user. If `db_user` doesn't exist in the database and `auto_create` is `True`, a new user is created using the value for `db_user` with `PUBLIC` permissions.  If a database user matching the value for `db_user` doesn't exist and `not` is `False`, then the command succeeds but the connection attempt will fail because the user doesn't exist in the database.
     */
    @JvmName("bcitljkxqteltbis")
    public suspend fun dbUser(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbUser = mapped
    }

    /**
     * @param value The number of seconds until the returned temporary password expires. Valid values are between `900` and `3600`. Default value is `900`.
     */
    @JvmName("ojyfqhcdotheunsl")
    public suspend fun durationSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.durationSeconds = mapped
    }

    internal fun build(): GetClusterCredentialsPlainArgs = GetClusterCredentialsPlainArgs(
        autoCreate = autoCreate,
        clusterIdentifier = clusterIdentifier ?: throw PulumiNullFieldException("clusterIdentifier"),
        dbGroups = dbGroups,
        dbName = dbName,
        dbUser = dbUser ?: throw PulumiNullFieldException("dbUser"),
        durationSeconds = durationSeconds,
    )
}
