@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.inputs

import com.pulumi.aws.redshift.inputs.GetDataSharesDataShare.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataShareArn ARN (Amazon Resource Name) of the data share.
 * @property managedBy Identifier of a datashare to show its managing entity.
 * @property producerArn ARN (Amazon Resource Name) of the producer.
 */
public data class GetDataSharesDataShare(
    public val dataShareArn: String,
    public val managedBy: String,
    public val producerArn: String,
) : ConvertibleToJava<com.pulumi.aws.redshift.inputs.GetDataSharesDataShare> {
    override fun toJava(): com.pulumi.aws.redshift.inputs.GetDataSharesDataShare =
        com.pulumi.aws.redshift.inputs.GetDataSharesDataShare.builder()
            .dataShareArn(dataShareArn.let({ args0 -> args0 }))
            .managedBy(managedBy.let({ args0 -> args0 }))
            .producerArn(producerArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataSharesDataShare].
 */
@PulumiTagMarker
public class GetDataSharesDataShareBuilder internal constructor() {
    private var dataShareArn: String? = null

    private var managedBy: String? = null

    private var producerArn: String? = null

    /**
     * @param value ARN (Amazon Resource Name) of the data share.
     */
    @JvmName("qxshpjclecohjlsv")
    public suspend fun dataShareArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataShareArn = mapped
    }

    /**
     * @param value Identifier of a datashare to show its managing entity.
     */
    @JvmName("wtlhnmanhxxnjgex")
    public suspend fun managedBy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedBy = mapped
    }

    /**
     * @param value ARN (Amazon Resource Name) of the producer.
     */
    @JvmName("lctybldkipxpdyqm")
    public suspend fun producerArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.producerArn = mapped
    }

    internal fun build(): GetDataSharesDataShare = GetDataSharesDataShare(
        dataShareArn = dataShareArn ?: throw PulumiNullFieldException("dataShareArn"),
        managedBy = managedBy ?: throw PulumiNullFieldException("managedBy"),
        producerArn = producerArn ?: throw PulumiNullFieldException("producerArn"),
    )
}
