@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.inputs

import com.pulumi.aws.redshift.inputs.GetDataSharesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDataShares.
 * @property dataShares An array of all data shares in the current region. See `data_shares` below.
 */
public data class GetDataSharesPlainArgs(
    public val dataShares: List<GetDataSharesDataShare>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.inputs.GetDataSharesPlainArgs> {
    override fun toJava(): com.pulumi.aws.redshift.inputs.GetDataSharesPlainArgs =
        com.pulumi.aws.redshift.inputs.GetDataSharesPlainArgs.builder()
            .dataShares(
                dataShares?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetDataSharesPlainArgs].
 */
@PulumiTagMarker
public class GetDataSharesPlainArgsBuilder internal constructor() {
    private var dataShares: List<GetDataSharesDataShare>? = null

    /**
     * @param value An array of all data shares in the current region. See `data_shares` below.
     */
    @JvmName("xedsgfoixhtpoown")
    public suspend fun dataShares(`value`: List<GetDataSharesDataShare>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dataShares = mapped
    }

    /**
     * @param argument An array of all data shares in the current region. See `data_shares` below.
     */
    @JvmName("rvnwotehlnmngshp")
    public suspend fun dataShares(argument: List<suspend GetDataSharesDataShareBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetDataSharesDataShareBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.dataShares = mapped
    }

    /**
     * @param argument An array of all data shares in the current region. See `data_shares` below.
     */
    @JvmName("yghdgsgppgadjobm")
    public suspend fun dataShares(vararg argument: suspend GetDataSharesDataShareBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetDataSharesDataShareBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.dataShares = mapped
    }

    /**
     * @param argument An array of all data shares in the current region. See `data_shares` below.
     */
    @JvmName("duvtdyukhvifueae")
    public suspend fun dataShares(argument: suspend GetDataSharesDataShareBuilder.() -> Unit) {
        val toBeMapped = listOf(GetDataSharesDataShareBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.dataShares = mapped
    }

    /**
     * @param values An array of all data shares in the current region. See `data_shares` below.
     */
    @JvmName("tysxsnmlohmvscql")
    public suspend fun dataShares(vararg values: GetDataSharesDataShare) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataShares = mapped
    }

    internal fun build(): GetDataSharesPlainArgs = GetDataSharesPlainArgs(
        dataShares = dataShares,
    )
}
