@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.inputs

import com.pulumi.aws.redshift.inputs.GetOrderableClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOrderableCluster.
 * @property clusterType Reshift Cluster typeE.g., `multi-node` or `single-node`
 * @property clusterVersion Redshift Cluster versionE.g., `1.0`
 * @property nodeType Redshift Cluster node typeE.g., `dc2.8xlarge`
 * @property preferredNodeTypes Ordered list of preferred Redshift Cluster node types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
 */
public data class GetOrderableClusterPlainArgs(
    public val clusterType: String? = null,
    public val clusterVersion: String? = null,
    public val nodeType: String? = null,
    public val preferredNodeTypes: List<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.inputs.GetOrderableClusterPlainArgs> {
    override fun toJava(): com.pulumi.aws.redshift.inputs.GetOrderableClusterPlainArgs =
        com.pulumi.aws.redshift.inputs.GetOrderableClusterPlainArgs.builder()
            .clusterType(clusterType?.let({ args0 -> args0 }))
            .clusterVersion(clusterVersion?.let({ args0 -> args0 }))
            .nodeType(nodeType?.let({ args0 -> args0 }))
            .preferredNodeTypes(preferredNodeTypes?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetOrderableClusterPlainArgs].
 */
@PulumiTagMarker
public class GetOrderableClusterPlainArgsBuilder internal constructor() {
    private var clusterType: String? = null

    private var clusterVersion: String? = null

    private var nodeType: String? = null

    private var preferredNodeTypes: List<String>? = null

    /**
     * @param value Reshift Cluster typeE.g., `multi-node` or `single-node`
     */
    @JvmName("bbcyctexqgnpxurp")
    public suspend fun clusterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clusterType = mapped
    }

    /**
     * @param value Redshift Cluster versionE.g., `1.0`
     */
    @JvmName("etcdiugikcbyyjjm")
    public suspend fun clusterVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clusterVersion = mapped
    }

    /**
     * @param value Redshift Cluster node typeE.g., `dc2.8xlarge`
     */
    @JvmName("peirofwnkkkpbbjj")
    public suspend fun nodeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nodeType = mapped
    }

    /**
     * @param value Ordered list of preferred Redshift Cluster node types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     */
    @JvmName("mwneppdwutcukaek")
    public suspend fun preferredNodeTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredNodeTypes = mapped
    }

    /**
     * @param values Ordered list of preferred Redshift Cluster node types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     */
    @JvmName("rmbputsvgvvhdwfb")
    public suspend fun preferredNodeTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredNodeTypes = mapped
    }

    internal fun build(): GetOrderableClusterPlainArgs = GetOrderableClusterPlainArgs(
        clusterType = clusterType,
        clusterVersion = clusterVersion,
        nodeType = nodeType,
        preferredNodeTypes = preferredNodeTypes,
    )
}
